/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.geometry;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.Geometry;
import org.citygml4j.geometry.Matrix;

public class Point
implements Geometry {
    private double x;
    private double y;
    private double z;

    public Point() {
    }

    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public Point(double singleValue) {
        this.y = this.z = singleValue;
        this.x = this.z;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public boolean isEqual(double singleValue) {
        return this.x == singleValue && this.y == singleValue && this.z == singleValue;
    }

    public boolean isEqual(double x, double y, double z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public void transform3D(Matrix m3) {
        if (m3 != null) {
            if (m3.getColumnDimension() != 4 || m3.getRowDimension() != 4) {
                throw new IllegalArgumentException("A 3D transformation requires a 4x4 matrix.");
            }
            Matrix v = new Matrix(new double[]{this.x, this.y, this.z, 1.0}, 4);
            v = m3.times(v);
            this.x = v.get(0, 0);
            this.y = v.get(1, 0);
            this.z = v.get(2, 0);
        }
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Point(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Point copy = target == null ? new Point() : (Point)target;
        copy.setX(copyBuilder.copy(this.x));
        copy.setY(copyBuilder.copy(this.y));
        copy.setZ(copyBuilder.copy(this.z));
        return copy;
    }

    public List<Double> toList() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(this.x);
        values.add(this.y);
        values.add(this.z);
        return values;
    }
}

