/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.ade.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.binding.ADEWalker;
import org.citygml4j.util.walker.Walker;

public class ADEWalkerHelper<T extends Walker> {
    private Deque<ADEWalker<T>> walkers = new ArrayDeque<ADEWalker<T>>();
    private Map<String, AbstractMap.SimpleEntry<ADEWalker<T>, Method>> methods = new HashMap<String, AbstractMap.SimpleEntry<ADEWalker<T>, Method>>();
    private Class<?> returnType;

    public void addADEWalker(ADEWalker<T> walker) {
        this.walkers.addFirst(walker);
        if (!this.methods.isEmpty()) {
            this.methods.clear();
        }
    }

    public Object invokeWalkerMethod(ADEModelObject adeModelObject, String methodName) {
        String key = this.getKey(adeModelObject, methodName);
        ADEWalker<T> walker2 = null;
        Method method = null;
        AbstractMap.SimpleEntry<ADEWalker<T>, Method> entry = this.methods.get(key);
        if (entry != null) {
            walker2 = entry.getKey();
            method = entry.getValue();
        } else {
            for (ADEWalker<T> walker2 : this.walkers) {
                if (walker2 == null) continue;
                try {
                    method = walker2.getClass().getMethod(methodName, adeModelObject.getClass());
                    method.setAccessible(true);
                    this.methods.put(key, new AbstractMap.SimpleEntry<ADEWalker<T>, Method>(walker2, method));
                    break;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                }
            }
            if (method == null) {
                this.methods.put(key, new AbstractMap.SimpleEntry<Object, Object>(null, null));
            }
        }
        if (method != null) {
            try {
                Object returnValue = method.invoke(walker2, adeModelObject);
                if (returnValue != null && this.returnType.isInstance(returnValue)) {
                    return returnValue;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void inferFunctionType(T parent, Class<?> genericSuperClass) {
        Class<?> cls = parent.getClass();
        while (cls.getSuperclass() != null && !cls.getSuperclass().equals(genericSuperClass)) {
            cls = cls.getSuperclass();
        }
        if (cls.getSuperclass() != null) {
            this.returnType = (Class)((ParameterizedType)cls.getGenericSuperclass()).getActualTypeArguments()[0];
        }
    }

    private String getKey(ADEModelObject adeModelObject, String methodName) {
        return adeModelObject.getClass().getName() + '.' + methodName;
    }
}

