/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.waterbody;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.citygml.waterbody.AbstractWaterBoundarySurface;
import org.citygml4j.model.citygml.waterbody.AbstractWaterObject;
import org.citygml4j.model.citygml.waterbody.BoundedByWaterSurfaceProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurveProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class WaterBody
extends AbstractWaterObject
implements StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private MultiCurveProperty lod0MultiCurve;
    private MultiCurveProperty lod1MultiCurve;
    private MultiSurfaceProperty lod0MultiSurface;
    private MultiSurfaceProperty lod1MultiSurface;
    private SolidProperty lod1Solid;
    private SolidProperty lod2Solid;
    private SolidProperty lod3Solid;
    private SolidProperty lod4Solid;
    private List<BoundedByWaterSurfaceProperty> boundedBySurface;
    private List<ADEComponent> ade;

    public WaterBody() {
    }

    public WaterBody(Module module) {
        super(module);
    }

    public void addBoundedBySurface(BoundedByWaterSurfaceProperty boundedBySurface) {
        this.getBoundedBySurface().add(boundedBySurface);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfWaterBody(ADEComponent ade) {
        this.getGenericApplicationPropertyOfWaterBody().add(ade);
    }

    public List<BoundedByWaterSurfaceProperty> getBoundedBySurface() {
        if (this.boundedBySurface == null) {
            this.boundedBySurface = new ChildList<BoundedByWaterSurfaceProperty>(this);
        }
        return this.boundedBySurface;
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfWaterBody() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiCurveProperty getLod0MultiCurve() {
        return this.lod0MultiCurve;
    }

    public MultiSurfaceProperty getLod0MultiSurface() {
        return this.lod0MultiSurface;
    }

    public MultiCurveProperty getLod1MultiCurve() {
        return this.lod1MultiCurve;
    }

    public MultiSurfaceProperty getLod1MultiSurface() {
        return this.lod1MultiSurface;
    }

    public SolidProperty getLod1Solid() {
        return this.lod1Solid;
    }

    public SolidProperty getLod2Solid() {
        return this.lod2Solid;
    }

    public SolidProperty getLod3Solid() {
        return this.lod3Solid;
    }

    public SolidProperty getLod4Solid() {
        return this.lod4Solid;
    }

    public boolean isSetBoundedBySurface() {
        return this.boundedBySurface != null && !this.boundedBySurface.isEmpty();
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfWaterBody() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod0MultiCurve() {
        return this.lod0MultiCurve != null;
    }

    public boolean isSetLod0MultiSurface() {
        return this.lod0MultiSurface != null;
    }

    public boolean isSetLod1MultiCurve() {
        return this.lod1MultiCurve != null;
    }

    public boolean isSetLod1MultiSurface() {
        return this.lod1MultiSurface != null;
    }

    public boolean isSetLod1Solid() {
        return this.lod1Solid != null;
    }

    public boolean isSetLod2Solid() {
        return this.lod2Solid != null;
    }

    public boolean isSetLod3Solid() {
        return this.lod3Solid != null;
    }

    public boolean isSetLod4Solid() {
        return this.lod4Solid != null;
    }

    public void setBoundedBySurface(List<BoundedByWaterSurfaceProperty> boundedBySurface) {
        this.boundedBySurface = new ChildList<BoundedByWaterSurfaceProperty>((ModelObject)this, boundedBySurface);
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setGenericApplicationPropertyOfWaterBody(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod0MultiCurve(MultiCurveProperty lod0MultiCurve) {
        this.lod0MultiCurve = ModelObjects.setParent(lod0MultiCurve, (ModelObject)this);
    }

    public void setLod0MultiSurface(MultiSurfaceProperty lod0MultiSurface) {
        this.lod0MultiSurface = ModelObjects.setParent(lod0MultiSurface, (ModelObject)this);
    }

    public void setLod1MultiCurve(MultiCurveProperty lod1MultiCurve) {
        this.lod1MultiCurve = ModelObjects.setParent(lod1MultiCurve, (ModelObject)this);
    }

    public void setLod1MultiSurface(MultiSurfaceProperty lod1MultiSurface) {
        this.lod1MultiSurface = ModelObjects.setParent(lod1MultiSurface, (ModelObject)this);
    }

    public void setLod1Solid(SolidProperty lod1Solid) {
        this.lod1Solid = ModelObjects.setParent(lod1Solid, (ModelObject)this);
    }

    public void setLod2Solid(SolidProperty lod2Solid) {
        this.lod2Solid = ModelObjects.setParent(lod2Solid, (ModelObject)this);
    }

    public void setLod3Solid(SolidProperty lod3Solid) {
        this.lod3Solid = ModelObjects.setParent(lod3Solid, (ModelObject)this);
    }

    public void setLod4Solid(SolidProperty lod4Solid) {
        this.lod4Solid = ModelObjects.setParent(lod4Solid, (ModelObject)this);
    }

    public void unsetBoundedBySurface() {
        this.boundedBySurface = ModelObjects.setNull(this.boundedBySurface);
    }

    public boolean unsetBoundedBySurface(BoundedByWaterSurfaceProperty boundedBySurface) {
        return this.isSetBoundedBySurface() && this.boundedBySurface.remove(boundedBySurface);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetGenericApplicationPropertyOfWaterBody() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfWaterBody(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfWaterBody() && this.ade.remove(ade);
    }

    public void unsetLod0MultiCurve() {
        this.lod0MultiCurve = ModelObjects.setNull(this.lod0MultiCurve);
    }

    public void unsetLod0MultiSurface() {
        this.lod0MultiSurface = ModelObjects.setNull(this.lod0MultiSurface);
    }

    public void unsetLod1MultiCurve() {
        this.lod1MultiCurve = ModelObjects.setNull(this.lod1MultiCurve);
    }

    public void unsetLod1MultiSurface() {
        this.lod1MultiSurface = ModelObjects.setNull(this.lod1MultiSurface);
    }

    public void unsetLod1Solid() {
        this.lod1Solid = ModelObjects.setNull(this.lod1Solid);
    }

    public void unsetLod2Solid() {
        this.lod2Solid = ModelObjects.setNull(this.lod2Solid);
    }

    public void unsetLod3Solid() {
        this.lod3Solid = ModelObjects.setNull(this.lod3Solid);
    }

    public void unsetLod4Solid() {
        this.lod4Solid = ModelObjects.setNull(this.lod4Solid);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.WATER_BODY;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        SolidProperty solidProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    solidProperty = this.lod1Solid;
                    break;
                }
                case 2: {
                    solidProperty = this.lod2Solid;
                    break;
                }
                case 3: {
                    solidProperty = this.lod3Solid;
                    break;
                }
                case 4: {
                    solidProperty = this.lod4Solid;
                }
            }
            if (solidProperty == null || !solidProperty.isSetSolid()) continue;
            boundedBy.updateEnvelope(solidProperty.getSolid().calcBoundingBox());
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 0; lod < 2; ++lod) {
            switch (lod) {
                case 0: {
                    multiSurfaceProperty = this.lod0MultiSurface;
                    break;
                }
                case 1: {
                    multiSurfaceProperty = this.lod1MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        MultiCurveProperty multiCurveProperty = null;
        for (int lod = 0; lod < 2; ++lod) {
            switch (lod) {
                case 0: {
                    multiCurveProperty = this.lod0MultiCurve;
                    break;
                }
                case 1: {
                    multiCurveProperty = this.lod1MultiCurve;
                }
            }
            if (multiCurveProperty == null || !multiCurveProperty.isSetMultiCurve()) continue;
            boundedBy.updateEnvelope(multiCurveProperty.getMultiCurve().calcBoundingBox());
        }
        if (this.isSetBoundedBySurface()) {
            for (BoundedByWaterSurfaceProperty boundedBySurfaceProperty : this.boundedBySurface) {
                if (!boundedBySurfaceProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((AbstractWaterBoundarySurface)boundedBySurfaceProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetGenericApplicationPropertyOfWaterBody()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfWaterBody()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(1, this.lod1Solid);
        lodRepresentation.addRepresentation(2, this.lod2Solid);
        lodRepresentation.addRepresentation(3, this.lod3Solid);
        lodRepresentation.addRepresentation(4, this.lod4Solid);
        lodRepresentation.addRepresentation(0, this.lod0MultiSurface);
        lodRepresentation.addRepresentation(1, this.lod1MultiSurface);
        lodRepresentation.addRepresentation(0, this.lod0MultiCurve);
        lodRepresentation.addRepresentation(1, this.lod1MultiCurve);
        return lodRepresentation;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new WaterBody(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        WaterBody copy = target == null ? new WaterBody() : (WaterBody)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetBoundedBySurface()) {
            for (BoundedByWaterSurfaceProperty boundedByWaterSurfaceProperty : this.boundedBySurface) {
                copyPart = (BoundedByWaterSurfaceProperty)copyBuilder.copy(boundedByWaterSurfaceProperty);
                copy.addBoundedBySurface((BoundedByWaterSurfaceProperty)copyPart);
                if (boundedByWaterSurfaceProperty == null || copyPart != boundedByWaterSurfaceProperty) continue;
                boundedByWaterSurfaceProperty.setParent(this);
            }
        }
        if (this.isSetLod0MultiCurve()) {
            copy.setLod0MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod0MultiCurve));
            if (copy.getLod0MultiCurve() == this.lod0MultiCurve) {
                this.lod0MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod1MultiCurve()) {
            copy.setLod1MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod1MultiCurve));
            if (copy.getLod1MultiCurve() == this.lod1MultiCurve) {
                this.lod1MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod0MultiSurface()) {
            copy.setLod0MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod0MultiSurface));
            if (copy.getLod0MultiSurface() == this.lod0MultiSurface) {
                this.lod0MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod1MultiSurface()) {
            copy.setLod1MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod1MultiSurface));
            if (copy.getLod1MultiSurface() == this.lod1MultiSurface) {
                this.lod1MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod1Solid()) {
            copy.setLod1Solid((SolidProperty)copyBuilder.copy(this.lod1Solid));
            if (copy.getLod1Solid() == this.lod1Solid) {
                this.lod1Solid.setParent(this);
            }
        }
        if (this.isSetLod2Solid()) {
            copy.setLod2Solid((SolidProperty)copyBuilder.copy(this.lod2Solid));
            if (copy.getLod2Solid() == this.lod2Solid) {
                this.lod2Solid.setParent(this);
            }
        }
        if (this.isSetLod3Solid()) {
            copy.setLod3Solid((SolidProperty)copyBuilder.copy(this.lod3Solid));
            if (copy.getLod3Solid() == this.lod3Solid) {
                this.lod3Solid.setParent(this);
            }
        }
        if (this.isSetLod4Solid()) {
            copy.setLod4Solid((SolidProperty)copyBuilder.copy(this.lod4Solid));
            if (copy.getLod4Solid() == this.lod4Solid) {
                this.lod4Solid.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfWaterBody()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfWaterBody((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

