/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.primitives.LineString;
import org.citygml4j.model.gml.geometry.primitives.LineStringProperty;

public class MultiLineString
extends AbstractGeometricAggregate {
    private List<LineStringProperty> lineStringMember;

    public MultiLineString() {
    }

    public MultiLineString(List<LineString> lineStrings) {
        for (LineString lineString : lineStrings) {
            this.addLineStringMember(new LineStringProperty(lineString));
        }
    }

    public MultiLineString(LineString ... lineStrings) {
        this(Arrays.asList(lineStrings));
    }

    public void addLineStringMember(LineStringProperty lineStringMember) {
        this.getLineStringMember().add(lineStringMember);
    }

    public List<LineStringProperty> getLineStringMember() {
        if (this.lineStringMember == null) {
            this.lineStringMember = new ChildList<LineStringProperty>(this);
        }
        return this.lineStringMember;
    }

    public boolean isSetLineStringMember() {
        return this.lineStringMember != null && !this.lineStringMember.isEmpty();
    }

    public void setLineStringMember(List<LineStringProperty> lineStringMember) {
        this.lineStringMember = new ChildList<LineStringProperty>((ModelObject)this, lineStringMember);
    }

    public void unsetLineStringMember() {
        this.lineStringMember = ModelObjects.setNull(this.lineStringMember);
    }

    public boolean unsetLineStringMember(LineStringProperty lineStringMember) {
        return this.isSetLineStringMember() && this.lineStringMember.remove(lineStringMember);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        if (this.isSetLineStringMember()) {
            for (LineStringProperty lineStringProperty : this.getLineStringMember()) {
                if (!lineStringProperty.isSetLineString()) continue;
                bbox.update(lineStringProperty.getLineString().calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_LINE_STRING;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiLineString(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiLineString copy = target == null ? new MultiLineString() : (MultiLineString)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetLineStringMember()) {
            for (LineStringProperty part : this.lineStringMember) {
                LineStringProperty copyPart = (LineStringProperty)copyBuilder.copy(part);
                copy.addLineStringMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

