/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.primitives.AbstractSolid;
import org.citygml4j.model.gml.geometry.primitives.SolidArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;

public class MultiSolid
extends AbstractGeometricAggregate {
    private List<SolidProperty> solidMember;
    private SolidArrayProperty solidMembers;

    public MultiSolid() {
    }

    public MultiSolid(List<? extends AbstractSolid> abstractSolids) {
        for (AbstractSolid abstractSolid : abstractSolids) {
            this.addSolidMember(new SolidProperty(abstractSolid));
        }
    }

    public MultiSolid(AbstractSolid ... abstractSolids) {
        this(Arrays.asList(abstractSolids));
    }

    public void addSolidMember(SolidProperty solidMember) {
        this.getSolidMember().add(solidMember);
    }

    public List<SolidProperty> getSolidMember() {
        if (this.solidMember == null) {
            this.solidMember = new ChildList<SolidProperty>(this);
        }
        return this.solidMember;
    }

    public SolidArrayProperty getSolidMembers() {
        return this.solidMembers;
    }

    public boolean isSetSolidMember() {
        return this.solidMember != null && !this.solidMember.isEmpty();
    }

    public boolean isSetSolidMembers() {
        return this.solidMembers != null;
    }

    public void setSolidMember(List<SolidProperty> solidMember) {
        this.solidMember = new ChildList<SolidProperty>((ModelObject)this, solidMember);
    }

    public void setSolidMembers(SolidArrayProperty solidMembers) {
        this.solidMembers = ModelObjects.setParent(solidMembers, (ModelObject)this);
    }

    public void unsetSolidMember() {
        this.solidMember = ModelObjects.setNull(this.solidMember);
    }

    public boolean unsetSolidMember(SolidProperty solidMember) {
        return this.isSetSolidMember() && this.solidMember.remove(solidMember);
    }

    public void unsetSolidMembers() {
        this.solidMembers = ModelObjects.setNull(this.solidMembers);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        SolidArrayProperty solidArrayProperty;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetSolidMember()) {
            for (SolidProperty solidProperty : this.getSolidMember()) {
                if (!solidProperty.isSetSolid()) continue;
                bbox.update(solidProperty.getSolid().calcBoundingBox());
            }
        }
        if (this.isSetSolidMembers() && (solidArrayProperty = this.getSolidMembers()).isSetSolid()) {
            for (AbstractSolid abstractSolid : solidArrayProperty.getSolid()) {
                bbox.update(abstractSolid.calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_SOLID;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiSolid(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiSolid copy = target == null ? new MultiSolid() : (MultiSolid)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetSolidMember()) {
            for (SolidProperty part : this.solidMember) {
                SolidProperty copyPart = (SolidProperty)copyBuilder.copy(part);
                copy.addSolidMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetSolidMembers()) {
            copy.setSolidMembers((SolidArrayProperty)copyBuilder.copy(this.solidMembers));
            if (copy.getSolidMembers() == this.solidMembers) {
                this.solidMembers.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

