/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.complexes;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;

public class CompositeSurface
extends AbstractSurface {
    private List<SurfaceProperty> surfaceMember;

    public CompositeSurface() {
    }

    public CompositeSurface(List<? extends AbstractSurface> abstractSurfaces) {
        for (AbstractSurface abstractSurface : abstractSurfaces) {
            this.addSurfaceMember(new SurfaceProperty(abstractSurface));
        }
    }

    public CompositeSurface(AbstractSurface ... abstractSurfaces) {
        this(Arrays.asList(abstractSurfaces));
    }

    public void addSurfaceMember(SurfaceProperty surfaceMember) {
        this.getSurfaceMember().add(surfaceMember);
    }

    public List<SurfaceProperty> getSurfaceMember() {
        if (this.surfaceMember == null) {
            this.surfaceMember = new ChildList<SurfaceProperty>(this);
        }
        return this.surfaceMember;
    }

    public boolean isSetSurfaceMember() {
        return this.surfaceMember != null && !this.surfaceMember.isEmpty();
    }

    public void setSurfaceMember(List<SurfaceProperty> surfaceMember) {
        this.surfaceMember = new ChildList<SurfaceProperty>((ModelObject)this, surfaceMember);
    }

    public void unsetSurfaceMember() {
        this.surfaceMember = ModelObjects.setNull(this.surfaceMember);
    }

    public boolean unsetSurfaceMember(SurfaceProperty surfaceMember) {
        return this.isSetSurfaceMember() && this.surfaceMember.remove(surfaceMember);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        if (this.isSetSurfaceMember()) {
            for (SurfaceProperty surfaceProperty : this.getSurfaceMember()) {
                if (!surfaceProperty.isSetSurface()) continue;
                bbox.update(surfaceProperty.getSurface().calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.COMPOSITE_SURFACE;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new CompositeSurface(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        CompositeSurface copy = target == null ? new CompositeSurface() : (CompositeSurface)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetSurfaceMember()) {
            for (SurfaceProperty part : this.surfaceMember) {
                SurfaceProperty copyPart = (SurfaceProperty)copyBuilder.copy(part);
                copy.addSurfaceMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

