/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.base.CoordinateListProvider;
import org.citygml4j.model.gml.basicTypes.Coordinates;
import org.citygml4j.model.gml.geometry.primitives.AbstractGeometricPrimitive;
import org.citygml4j.model.gml.geometry.primitives.Coord;
import org.citygml4j.model.gml.geometry.primitives.DirectPosition;

public class Point
extends AbstractGeometricPrimitive
implements CoordinateListProvider {
    private DirectPosition pos;
    private Coordinates coordinates;
    private Coord coord;

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        List<Double> points = this.toList3d();
        for (int i = 0; i < points.size(); i += 3) {
            bbox.update(points.get(i), points.get(i + 1), points.get(i + 2));
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.POINT;
    }

    public Coord getCoord() {
        return this.coord;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public DirectPosition getPos() {
        return this.pos;
    }

    public boolean isSetCoord() {
        return this.coord != null;
    }

    public boolean isSetCoordinates() {
        return this.coordinates != null;
    }

    public boolean isSetPos() {
        return this.pos != null;
    }

    public void setCoord(Coord coord) {
        this.coord = ModelObjects.setParent(coord, (ModelObject)this);
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = ModelObjects.setParent(coordinates, (ModelObject)this);
    }

    public void setPos(DirectPosition pos) {
        this.pos = ModelObjects.setParent(pos, (ModelObject)this);
    }

    @Override
    public List<Double> toList3d() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        if (this.isSetPos()) {
            tmp.addAll(this.pos.toList3d());
        } else if (this.isSetCoord()) {
            tmp.addAll(this.coord.toList3d());
        } else if (this.isSetCoordinates()) {
            tmp.addAll(this.coordinates.toList3d());
        }
        return tmp;
    }

    public void unsetCoord() {
        this.coord = ModelObjects.setNull(this.coord);
    }

    public void unsetCoordinates() {
        this.coordinates = ModelObjects.setNull(this.coordinates);
    }

    public void unsetPos() {
        this.pos = ModelObjects.setNull(this.pos);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Point copy = target == null ? new Point() : (Point)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetPos()) {
            copy.setPos((DirectPosition)copyBuilder.copy(this.pos));
            if (copy.getPos() == this.pos) {
                this.pos.setParent(this);
            }
        }
        if (this.isSetCoordinates()) {
            copy.setCoordinates((Coordinates)copyBuilder.copy(this.coordinates));
            if (copy.getCoordinates() == this.coordinates) {
                this.coordinates.setParent(this);
            }
        }
        if (this.isSetCoord()) {
            copy.setCoord((Coord)copyBuilder.copy(this.coord));
            if (copy.getCoord() == this.coord) {
                this.coord.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Point(), copyBuilder);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

