/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.grids;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.geometry.Matrix;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.model.gml.geometry.primitives.Vector;
import org.citygml4j.model.gml.grids.Grid;

public class RectifiedGrid
extends Grid {
    private PointProperty origin;
    private List<Vector> offsetVector;

    public void addOffsetVector(Vector offsetVector) {
        this.getOffsetVector().add(offsetVector);
    }

    public PointProperty getOrigin() {
        return this.origin;
    }

    public List<Vector> getOffsetVector() {
        if (this.offsetVector == null) {
            this.offsetVector = new ChildList<Vector>(this);
        }
        return this.offsetVector;
    }

    public boolean isSetOrigin() {
        return this.origin != null;
    }

    public boolean isSetOffsetVector() {
        return this.offsetVector != null && !this.offsetVector.isEmpty();
    }

    public void setOrigin(PointProperty origin) {
        this.origin = ModelObjects.setParent(origin, (ModelObject)this);
    }

    public void setOffsetVector(List<Vector> offsetVector) {
        this.offsetVector = new ChildList<Vector>((ModelObject)this, offsetVector);
    }

    public void unsetOrigin() {
        this.origin = ModelObjects.setNull(this.origin);
    }

    public boolean unsetOffsetVector(Vector offsetVector) {
        return this.isSetOffsetVector() && this.offsetVector.remove(offsetVector);
    }

    public void unsetOffsetVector() {
        this.offsetVector = ModelObjects.setNull(this.offsetVector);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        if (!(this.isSetOrigin() && this.origin.isSetPoint() && this.isSetOffsetVector() && this.offsetVector.size() >= this.getDimension())) {
            return null;
        }
        BoundingBox gridLimits = super.calcBoundingBox();
        if (gridLimits == null) {
            return null;
        }
        BoundingBox bbox = new BoundingBox();
        Matrix[] offsetVectors = new Matrix[]{this.getDimension() >= 1 ? new Matrix(this.offsetVector.get(0).toList3d(), 3) : new Matrix(3, 1, 0.0), this.getDimension() >= 2 ? new Matrix(this.offsetVector.get(1).toList3d(), 3) : new Matrix(3, 1, 0.0), this.getDimension() >= 3 ? new Matrix(this.offsetVector.get(2).toList3d(), 3) : new Matrix(3, 1, 0.0)};
        Matrix origin = new Matrix(this.origin.getPoint().toList3d(), 3);
        List<Double> limits = gridLimits.toList();
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    double[] cornerPoint = origin.plus(offsetVectors[0].times(limits.get(x * 3))).plus(offsetVectors[1].times(limits.get(1 + y * 3))).plus(offsetVectors[2].times(limits.get(2 + z * 3))).getColumnPackedCopy();
                    bbox.update(cornerPoint[0], cornerPoint[1], cornerPoint[2]);
                }
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.RECTIFIED_GRID;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        RectifiedGrid copy = target == null ? new RectifiedGrid() : (RectifiedGrid)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetOffsetVector()) {
            for (Vector part : this.offsetVector) {
                Vector copyPart = (Vector)copyBuilder.copy(part);
                copy.addOffsetVector(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetOrigin()) {
            copy.setOrigin((PointProperty)copyBuilder.copy(this.origin));
            if (copy.getOrigin() == this.origin) {
                this.origin.setParent(this);
            }
        }
        copy.unsetParent();
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new RectifiedGrid(), copyBuilder);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

