/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.valueObjects;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.valueObjects.Value;
import org.citygml4j.model.gml.valueObjects.ValueArrayProperty;
import org.citygml4j.model.gml.valueObjects.ValueProperty;

public class CompositeValue
extends AbstractGML {
    private List<ValueProperty> valueComponent;
    private ValueArrayProperty valueComponents;

    public CompositeValue() {
    }

    public CompositeValue(List<Value> values) {
        for (Value value : values) {
            this.addValueComponent(new ValueProperty(value));
        }
    }

    public CompositeValue(Value ... values) {
        this(Arrays.asList(values));
    }

    public List<ValueProperty> getValueComponent() {
        if (this.valueComponent == null) {
            this.valueComponent = new ChildList<ValueProperty>(this);
        }
        return this.valueComponent;
    }

    public ValueArrayProperty getValueComponents() {
        return this.valueComponents;
    }

    public boolean isSetValueComponent() {
        return this.valueComponent != null && !this.valueComponent.isEmpty();
    }

    public boolean isSetValueComponents() {
        return this.valueComponents != null;
    }

    public void addValueComponent(ValueProperty valueComponent) {
        this.getValueComponent().add(valueComponent);
    }

    public void setValueComponent(List<ValueProperty> valueComponent) {
        this.valueComponent = new ChildList<ValueProperty>((ModelObject)this, valueComponent);
    }

    public void setValueComponents(ValueArrayProperty valueComponents) {
        this.valueComponents = ModelObjects.setParent(valueComponents, (ModelObject)this);
    }

    public boolean unsetValueComponent(ValueProperty valueComponent) {
        return this.isSetValueComponent() && this.valueComponent.remove(valueComponent);
    }

    public void unsetValueComponent() {
        this.valueComponent = ModelObjects.setNull(this.valueComponent);
    }

    public void unsetValueComponents() {
        this.valueComponents = ModelObjects.setNull(this.valueComponents);
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.COMPOSITE_VALUE;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        CompositeValue copy = target == null ? new CompositeValue() : (CompositeValue)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetValueComponent()) {
            for (ValueProperty part : this.valueComponent) {
                ValueProperty copyPart = (ValueProperty)copyBuilder.copy(part);
                copy.addValueComponent(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetValueComponents()) {
            copy.setValueComponents((ValueArrayProperty)copyBuilder.copy(this.valueComponents));
            if (copy.getValueComponents() == this.valueComponents) {
                this.valueComponents.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new CompositeValue(), copyBuilder);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

