/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.internal.jama;

import java.io.Serializable;
import org.citygml4j.geometry.Matrix;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;
    private static final long serialVersionUID = 1L;

    public CholeskyDecomposition(Matrix Arg) {
        double[][] A2 = Arg.getArray();
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        for (int j = 0; j < this.n; ++j) {
            int k;
            double[] Lrowj = this.L[j];
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double[] Lrowk = this.L[k];
                double s2 = 0.0;
                for (int i = 0; i < k; ++i) {
                    s2 += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s2 = (A2[j][k] - s2) / this.L[k][k];
                d += s2 * s2;
                this.isspd &= A2[k][j] == A2[j][k];
            }
            this.isspd &= (d = A2[j][j] - d) > 0.0;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
            for (k = j + 1; k < this.n; ++k) {
                this.L[j][k] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix B) {
        int i;
        int j;
        int k;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = B.getArrayCopy();
        int nx = B.getColumnDimension();
        for (k = 0; k < this.n; ++k) {
            j = 0;
            while (j < nx) {
                for (i = 0; i < k; ++i) {
                    double[] dArray = X[k];
                    int n = j;
                    dArray[n] = dArray[n] - X[i][j] * this.L[k][i];
                }
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                for (i = k + 1; i < this.n; ++i) {
                    double[] dArray = X[k];
                    int n = j;
                    dArray[n] = dArray[n] - X[i][j] * this.L[i][k];
                }
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
        }
        return new Matrix(X, this.n, nx);
    }
}

