/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.internal.jama;

import java.io.Serializable;
import org.citygml4j.geometry.Matrix;
import org.citygml4j.util.internal.jama.Maths;

public class EigenvalueDecomposition
implements Serializable {
    private int n;
    private boolean issymmetric;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;
    private static final long serialVersionUID = 1L;

    private void tred2() {
        int i;
        int j;
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V[this.n - 1][j];
        }
        for (i = this.n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h2 = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    this.d[j2] = this.V[i - 1][j2];
                    this.V[i][j2] = 0.0;
                    this.V[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h2 += this.d[k] * this.d[k];
                }
                double f = this.d[i - 1];
                double g2 = Math.sqrt(h2);
                if (f > 0.0) {
                    g2 = -g2;
                }
                this.e[i] = scale * g2;
                h2 -= f * g2;
                this.d[i - 1] = f - g2;
                for (j4 = 0; j4 < i; ++j4) {
                    this.e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    this.V[j4][i] = f = this.d[j4];
                    g2 = this.e[j4] + this.V[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g2 += this.V[k2][j4] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V[k2][j4] * f;
                    }
                    this.e[j4] = g2;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n = j4;
                    this.e[n] = this.e[n] / h2;
                    f += this.e[j4] * this.d[j4];
                }
                double hh = f / (h2 + h2);
                for (j3 = 0; j3 < i; ++j3) {
                    int n = j3;
                    this.e[n] = this.e[n] - hh * this.d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = this.d[j3];
                    g2 = this.e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = this.V[k3];
                        int n = j3;
                        dArray[n] = dArray[n] - (f * this.e[k3] + g2 * this.d[k3]);
                    }
                    this.d[j3] = this.V[i - 1][j3];
                    this.V[i][j3] = 0.0;
                }
            }
            this.d[i] = h2;
        }
        for (i = 0; i < this.n - 1; ++i) {
            int k;
            this.V[this.n - 1][i] = this.V[i][i];
            this.V[i][i] = 1.0;
            double h3 = this.d[i + 1];
            if (h3 != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d[k] = this.V[k][i + 1] / h3;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g3 = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g3 += this.V[k4][i + 1] * this.V[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = this.V[k4];
                        int n = j5;
                        dArray[n] = dArray[n] - g3 * this.d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.V[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V[this.n - 1][j];
            this.V[this.n - 1][j] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m3;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m3 = l; m3 < this.n && !(Math.abs(this.e[m3]) <= eps * tst1); ++m3) {
            }
            if (m3 > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g2 = this.d[l];
                    double p = (this.d[l + 1] - g2) / (2.0 * this.e[l]);
                    double r = Maths.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h2 = g2 - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h2;
                    }
                    f += h2;
                    p = this.d[m3];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s2 = 0.0;
                    double s22 = 0.0;
                    for (int i2 = m3 - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s22 = s2;
                        g2 = c * this.e[i2];
                        h2 = c * p;
                        r = Maths.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s2 * r;
                        s2 = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s2 * g2;
                        this.d[i2 + 1] = h2 + s2 * (c * g2 + s2 * this.d[i2]);
                        for (int k = 0; k < this.n; ++k) {
                            h2 = this.V[k][i2 + 1];
                            this.V[k][i2 + 1] = s2 * this.V[k][i2] + c * h2;
                            this.V[k][i2] = c * this.V[k][i2] - s2 * h2;
                        }
                    }
                    p = -s2 * s22 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s2 * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d[i];
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.V[j][i];
                this.V[j][i] = this.V[j][k];
                this.V[j][k] = p;
            }
        }
    }

    private void orthes() {
        int m3;
        int low = 0;
        int high = this.n - 1;
        for (m3 = low + 1; m3 <= high - 1; ++m3) {
            double f;
            double scale = 0.0;
            for (int i = m3; i <= high; ++i) {
                scale += Math.abs(this.H[i][m3 - 1]);
            }
            if (scale == 0.0) continue;
            double h2 = 0.0;
            for (int i = high; i >= m3; --i) {
                this.ort[i] = this.H[i][m3 - 1] / scale;
                h2 += this.ort[i] * this.ort[i];
            }
            double g2 = Math.sqrt(h2);
            if (this.ort[m3] > 0.0) {
                g2 = -g2;
            }
            h2 -= this.ort[m3] * g2;
            this.ort[m3] = this.ort[m3] - g2;
            for (int j = m3; j < this.n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m3; --i) {
                    f += this.ort[i] * this.H[i][j];
                }
                f /= h2;
                for (i = m3; i <= high; ++i) {
                    double[] dArray = this.H[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * this.ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m3; --j) {
                    f += this.ort[j] * this.H[i][j];
                }
                f /= h2;
                for (j = m3; j <= high; ++j) {
                    double[] dArray = this.H[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * this.ort[j];
                }
            }
            this.ort[m3] = scale * this.ort[m3];
            this.H[m3][m3 - 1] = scale * g2;
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.V[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (m3 = high - 1; m3 >= low + 1; --m3) {
            if (this.H[m3][m3 - 1] == 0.0) continue;
            for (int i = m3 + 1; i <= high; ++i) {
                this.ort[i] = this.H[i][m3 - 1];
            }
            for (int j = m3; j <= high; ++j) {
                int i;
                double g3 = 0.0;
                for (i = m3; i <= high; ++i) {
                    g3 += this.ort[i] * this.V[i][j];
                }
                g3 = g3 / this.ort[m3] / this.H[m3][m3 - 1];
                for (i = m3; i <= high; ++i) {
                    double[] dArray = this.V[i];
                    int n = j;
                    dArray[n] = dArray[n] + g3 * this.ort[i];
                }
            }
        }
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        double y;
        int i;
        int j;
        double x;
        double w;
        int l;
        int j2;
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s2 = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < low | i2 > high) {
                this.d[i2] = this.H[i2][i2];
                this.e[i2] = 0.0;
            }
            for (j2 = Math.max(i2 - 1, 0); j2 < nn; ++j2) {
                norm += Math.abs(this.H[i2][j2]);
            }
        }
        int iter = 0;
        while (n >= low) {
            int m3;
            for (l = n; l > low; --l) {
                s2 = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                if (s2 == 0.0) {
                    s2 = norm;
                }
                if (Math.abs(this.H[l][l - 1]) < eps * s2) break;
            }
            if (l == n) {
                this.H[n][n] = this.H[n][n] + exshift;
                this.d[n] = this.H[n][n];
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H[n][n - 1] * this.H[n - 1][n];
                p = (this.H[n - 1][n - 1] - this.H[n][n]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                this.H[n][n] = this.H[n][n] + exshift;
                this.H[n - 1][n - 1] = this.H[n - 1][n - 1] + exshift;
                x = this.H[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = this.H[n][n - 1];
                    s2 = Math.abs(x) + Math.abs(z);
                    p = x / s2;
                    q = z / s2;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = this.H[n - 1][j];
                        this.H[n - 1][j] = q * z + p * this.H[n][j];
                        this.H[n][j] = q * this.H[n][j] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = this.H[i][n - 1];
                        this.H[i][n - 1] = q * z + p * this.H[i][n];
                        this.H[i][n] = q * this.H[i][n] - p * z;
                    }
                    for (i = low; i <= high; ++i) {
                        z = this.V[i][n - 1];
                        this.V[i][n - 1] = q * z + p * this.V[i][n];
                        this.V[i][n] = q * this.V[i][n] - p * z;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H[n][n];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this.H[n - 1][n - 1];
                w = this.H[n][n - 1] * this.H[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = low;
                while (i <= n) {
                    double[] dArray = this.H[i];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] - x;
                }
                s2 = Math.abs(this.H[n][n - 1]) + Math.abs(this.H[n - 1][n - 2]);
                x = y = 0.75 * s2;
                w = -0.4375 * s2 * s2;
            }
            if (iter == 30) {
                s2 = (y - x) / 2.0;
                if ((s2 = s2 * s2 + w) > 0.0) {
                    s2 = Math.sqrt(s2);
                    if (y < x) {
                        s2 = -s2;
                    }
                    s2 = x - w / ((y - x) / 2.0 + s2);
                    i = low;
                    while (i <= n) {
                        double[] dArray = this.H[i];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] - s2;
                    }
                    exshift += s2;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m3 = n - 2; m3 >= l; --m3) {
                z = this.H[m3][m3];
                r = x - z;
                s2 = y - z;
                p = (r * s2 - w) / this.H[m3 + 1][m3] + this.H[m3][m3 + 1];
                q = this.H[m3 + 1][m3 + 1] - z - r - s2;
                r = this.H[m3 + 2][m3 + 1];
                s2 = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m3 == l || Math.abs(this.H[m3][m3 - 1]) * (Math.abs(q /= s2) + Math.abs(r /= s2)) < eps * (Math.abs(p /= s2) * (Math.abs(this.H[m3 - 1][m3 - 1]) + Math.abs(z) + Math.abs(this.H[m3 + 1][m3 + 1])))) break;
            }
            for (int i3 = m3 + 2; i3 <= n; ++i3) {
                this.H[i3][i3 - 2] = 0.0;
                if (i3 <= m3 + 2) continue;
                this.H[i3][i3 - 3] = 0.0;
            }
            for (int k = m3; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m3) {
                    p = this.H[k][k - 1];
                    q = this.H[k + 1][k - 1];
                    r = notlast ? this.H[k + 2][k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x == 0.0) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s2 = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s2 = -s2;
                }
                if (s2 == 0.0) continue;
                if (k != m3) {
                    this.H[k][k - 1] = -s2 * x;
                } else if (l != m3) {
                    this.H[k][k - 1] = -this.H[k][k - 1];
                }
                x = (p += s2) / s2;
                y = q / s2;
                z = r / s2;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = this.H[k][j3] + q * this.H[k + 1][j3];
                    if (notlast) {
                        this.H[k + 2][j3] = this.H[k + 2][j3] - (p += r * this.H[k + 2][j3]) * z;
                    }
                    this.H[k][j3] = this.H[k][j3] - p * x;
                    this.H[k + 1][j3] = this.H[k + 1][j3] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * this.H[i4][k] + y * this.H[i4][k + 1];
                    if (notlast) {
                        this.H[i4][k + 2] = this.H[i4][k + 2] - (p += z * this.H[i4][k + 2]) * r;
                    }
                    this.H[i4][k] = this.H[i4][k] - p;
                    this.H[i4][k + 1] = this.H[i4][k + 1] - p * q;
                }
                for (i4 = low; i4 <= high; ++i4) {
                    p = x * this.V[i4][k] + y * this.V[i4][k + 1];
                    if (notlast) {
                        this.V[i4][k + 2] = this.V[i4][k + 2] - (p += z * this.V[i4][k + 2]) * r;
                    }
                    this.V[i4][k] = this.V[i4][k] - p;
                    this.V[i4][k + 1] = this.V[i4][k + 1] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.H[n][n] = 1.0;
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = this.H[i][i] - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += this.H[i][j4] * this.H[j4][n];
                    }
                    if (this.e[i] < 0.0) {
                        z = w;
                        s2 = r;
                        continue;
                    }
                    l = i;
                    if (this.e[i] == 0.0) {
                        this.H[i][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = this.H[i][i + 1];
                        y = this.H[i + 1][i];
                        q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                        this.H[i][n] = t = (x * s2 - z * r) / q;
                        this.H[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s2 - y * t) / z;
                    }
                    t = Math.abs(this.H[i][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        this.H[j4][n] = this.H[j4][n] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.H[n][n - 1]) > Math.abs(this.H[n - 1][n])) {
                this.H[n - 1][n - 1] = q / this.H[n][n - 1];
                this.H[n - 1][n] = -(this.H[n][n] - p) / this.H[n][n - 1];
            } else {
                this.cdiv(0.0, -this.H[n - 1][n], this.H[n - 1][n - 1] - p, q);
                this.H[n - 1][n - 1] = this.cdivr;
                this.H[n - 1][n] = this.cdivi;
            }
            this.H[n][n - 1] = 0.0;
            this.H[n][n] = 1.0;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = 0.0;
                double sa = 0.0;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += this.H[i][j5] * this.H[j5][n - 1];
                    sa += this.H[i][j5] * this.H[j5][n];
                }
                w = this.H[i][i] - p;
                if (this.e[i] < 0.0) {
                    z = w;
                    r = ra;
                    s2 = sa;
                    continue;
                }
                l = i;
                if (this.e[i] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this.H[i][n - 1] = this.cdivr;
                    this.H[i][n] = this.cdivi;
                } else {
                    double vi;
                    x = this.H[i][i + 1];
                    y = this.H[i + 1][i];
                    double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                    if (vr == 0.0 & (vi = (this.d[i] - p) * 2.0 * q) == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s2 - z * sa - q * ra, vr, vi);
                    this.H[i][n - 1] = this.cdivr;
                    this.H[i][n] = this.cdivi;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        this.H[i + 1][n - 1] = (-ra - w * this.H[i][n - 1] + q * this.H[i][n]) / x;
                        this.H[i + 1][n] = (-sa - w * this.H[i][n] - q * this.H[i][n - 1]) / x;
                    } else {
                        this.cdiv(-r - y * this.H[i][n - 1], -s2 - y * this.H[i][n], z, q);
                        this.H[i + 1][n - 1] = this.cdivr;
                        this.H[i + 1][n] = this.cdivi;
                    }
                }
                t = Math.max(Math.abs(this.H[i][n - 1]), Math.abs(this.H[i][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i; j5 <= n; ++j5) {
                    this.H[j5][n - 1] = this.H[j5][n - 1] / t;
                    this.H[j5][n] = this.H[j5][n] / t;
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (!(i5 < low | i5 > high)) continue;
            for (j = i5; j < nn; ++j) {
                this.V[i5][j] = this.H[i5][j];
            }
        }
        for (j2 = nn - 1; j2 >= low; --j2) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (int k = low; k <= Math.min(j2, high); ++k) {
                    z += this.V[i][k] * this.H[k][j2];
                }
                this.V[i][j2] = z;
            }
        }
    }

    public EigenvalueDecomposition(Matrix Arg) {
        int i;
        double[][] A2 = Arg.getArray();
        this.n = Arg.getColumnDimension();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = true;
        int j = 0;
        while (j < this.n & this.issymmetric) {
            i = 0;
            while (i < this.n & this.issymmetric) {
                this.issymmetric = A2[i][j] == A2[j][i];
                ++i;
            }
            ++j;
        }
        if (this.issymmetric) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                for (int j2 = 0; j2 < this.n; ++j2) {
                    this.V[i2][j2] = A2[i2][j2];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (j = 0; j < this.n; ++j) {
                for (i = 0; i < this.n; ++i) {
                    this.H[i][j] = A2[i][j];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] D = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                D[i][j] = 0.0;
            }
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                D[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D[i][i - 1] = this.e[i];
        }
        return X;
    }
}

