/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.schema;

import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.citygml4j.xml.schema.ElementDecl;
import org.citygml4j.xml.schema.SchemaHandler;
import org.citygml4j.xml.schema.SchemaWalker;

public class Schema {
    final XSSchemaSet schemaSet;
    final SchemaHandler handler;
    final XSSchema schema;
    final String namespaceURI;
    private final HashMap<String, ElementDecl> uniqueElements;
    private final HashMap<String, List<ElementDecl>> multipleElements;
    private final HashMap<ElementDecl, HashMap<String, ElementDecl>> localElements;

    public Schema(XSSchemaSet schemaSet, String namespaceURI, SchemaHandler handler) {
        this.schemaSet = schemaSet;
        this.handler = handler;
        this.namespaceURI = namespaceURI;
        this.schema = schemaSet.getSchema(namespaceURI);
        if (this.schema == null) {
            throw new IllegalStateException("no XSSchema associated with the namespace '" + namespaceURI + "'.");
        }
        this.uniqueElements = new HashMap();
        this.multipleElements = new HashMap();
        this.localElements = new HashMap();
    }

    public XSSchema getXSSchema() {
        return this.schema;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public XSSchemaSet getXSSchemaSet() {
        return this.schemaSet;
    }

    public ElementDecl getGlobalElementDecl(String localName) {
        XSElementDecl decl = this.schema.getElementDecl(localName);
        return decl != null ? new ElementDecl(decl, this) : null;
    }

    public ElementDecl getElementDecl(String localName, ElementDecl parent) {
        ElementDecl element = null;
        HashMap<String, ElementDecl> local = null;
        if (parent != null && (local = this.localElements.get(parent)) != null) {
            element = local.get(localName);
        }
        if (element == null) {
            List<ElementDecl> candidates = this.getElementDecls(localName);
            if (candidates.size() == 1) {
                element = candidates.get(0);
            } else if (parent != null) {
                List<XSElementDecl> children = parent.getChildElements();
                for (ElementDecl candidate : candidates) {
                    if (candidate.isGlobal()) {
                        for (XSElementDecl child : children) {
                            if (!child.canBeSubstitutedBy(candidate.getXSElementDecl())) continue;
                            element = candidate;
                            break;
                        }
                        if (element == null) continue;
                        break;
                    }
                    if (!children.contains(candidate.getXSElementDecl())) continue;
                    element = candidate;
                    break;
                }
                if (element != null) {
                    if (local == null) {
                        local = new HashMap();
                        this.localElements.put(parent, local);
                    }
                    local.put(localName, element);
                }
            }
        }
        return element;
    }

    public List<ElementDecl> getElementDecls(final String localName) {
        if (this.multipleElements.containsKey(localName)) {
            return this.multipleElements.get(localName);
        }
        final ArrayList<ElementDecl> elements = new ArrayList<ElementDecl>();
        ElementDecl element = this.uniqueElements.get(localName);
        if (element != null) {
            elements.add(element);
        } else {
            SchemaWalker schemaWalker = new SchemaWalker(){

                @Override
                public void schema(XSSchema schema) {
                    for (XSElementDecl e : schema.getElementDecls().values()) {
                        if (!this.shouldWalk() || !this.addToVisited(e)) continue;
                        this.elementDecl(e);
                    }
                    for (XSComplexType t : schema.getComplexTypes().values()) {
                        if (!this.shouldWalk() || !this.addToVisited(t)) continue;
                        t.visit(this);
                    }
                }

                @Override
                public void elementDecl(XSElementDecl decl) {
                    if (localName.equals(decl.getName()) && Schema.this.schema.getTargetNamespace().equals(decl.getTargetNamespace())) {
                        elements.add(new ElementDecl(decl, Schema.this));
                    }
                    if (decl.getType().isLocal() && this.shouldWalk() && this.addToVisited(decl.getType())) {
                        decl.getType().visit(this);
                    }
                }

                @Override
                public void complexType(XSComplexType type) {
                    if (this.shouldWalk() && this.addToVisited(type.getContentType())) {
                        type.getContentType().visit(this);
                    }
                }

                @Override
                public void attGroupDecl(XSAttGroupDecl decl) {
                }

                @Override
                public void attributeDecl(XSAttributeDecl decl) {
                }

                @Override
                public void attributeUse(XSAttributeUse use) {
                }

                @Override
                public void simpleType(XSSimpleType simpleType2) {
                }
            };
            schemaWalker.visit(this.schema);
            if (elements.size() > 1) {
                this.multipleElements.put(localName, elements);
            } else if (elements.size() == 1) {
                this.uniqueElements.put(localName, (ElementDecl)elements.get(0));
            }
        }
        return elements;
    }

    public boolean haveSameTypeDefinition(List<ElementDecl> elementDecls) {
        Iterator<ElementDecl> iter = elementDecls.iterator();
        ElementDecl first = iter.next();
        XSType refType = first.getXSElementDecl().getType();
        while (iter.hasNext()) {
            if (iter.next().getXSElementDecl().getType() == refType) continue;
            return false;
        }
        return true;
    }
}

