/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.schema;

import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.citygml4j.CityGMLContext;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.module.Modules;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.citygml4j.xml.schema.Schema;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SchemaHandler {
    private static SchemaHandler instance = null;
    private final Set<XSSchemaSet> schemaSets = new HashSet<XSSchemaSet>();
    private final Map<String, String> schemaLocations = new HashMap<String, String>();
    private final Map<String, String> visited = new LinkedHashMap<String, String>();
    private final Map<String, Schema> schemas = new HashMap<String, Schema>();
    private SAXParserFactory saxParserFactory;
    private EntityResolver schemaEntityResolver;
    private ErrorHandler schemaErrorHandler;
    private AnnotationParserFactory annotationParserFactory;

    public static synchronized SchemaHandler newInstance() throws SAXException {
        if (instance == null) {
            instance = new SchemaHandler();
            URL schemaURL = SchemaHandler.class.getResource("/org/citygml4j/schemas/citygml4j.xsd");
            if (schemaURL == null) {
                throw new SAXException("Failed to parse CityGML schemas. Could not find '/org/citygml4j/schemas/citygml4j.xsd' on classpath.");
            }
            instance.parse(schemaURL.toString());
        }
        SchemaHandler schemaHandler = new SchemaHandler();
        schemaHandler.schemaSets.addAll(SchemaHandler.instance.schemaSets);
        schemaHandler.visited.putAll(SchemaHandler.instance.visited);
        schemaHandler.schemaLocations.put("http://www.citygml.org/citygml/1/0/0", CityGMLContext.class.getResource("/org/citygml4j/schemas/citygml/0.4.0/CityGML.xsd").toString());
        CityGMLContext context = CityGMLContext.getInstance();
        if (context.hasADEContexts()) {
            for (ADEContext adeContext : CityGMLContext.getInstance().getADEContexts()) {
                for (ADEModule adeModule : adeContext.getADEModules()) {
                    URL schemaResource = adeModule.getSchemaResource();
                    if (schemaResource == null) continue;
                    try {
                        schemaHandler.parse(schemaResource.toURI().toString());
                    }
                    catch (URISyntaxException e) {
                        throw new SAXException("Failed to parse XML schema file for ADE namespace '" + adeModule.getNamespaceURI() + "'.", e);
                    }
                }
            }
        }
        return schemaHandler;
    }

    private SchemaHandler() {
    }

    public void reset() {
        this.schemaSets.clear();
        this.schemaLocations.clear();
        this.visited.clear();
        this.schemas.clear();
        this.schemaSets.addAll(SchemaHandler.instance.schemaSets);
        this.visited.putAll(SchemaHandler.instance.visited);
    }

    public Schema getSchema(String namespaceURI) {
        XSSchemaSet schemaSet;
        Schema schema = this.schemas.get(namespaceURI);
        if (schema != null) {
            return schema;
        }
        if ("http://www.citygml.org/citygml/1/0/0".equals(namespaceURI)) {
            try {
                this.parse(this.schemaLocations.get(namespaceURI));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        if ((schemaSet = this.getXSSchemaSet(namespaceURI)) != null) {
            schema = new Schema(schemaSet, namespaceURI, this);
            this.schemas.put(namespaceURI, schema);
        }
        return schema;
    }

    private XSSchemaSet getXSSchemaSet(String namespaceURI) {
        for (XSSchemaSet schemaSet : this.schemaSets) {
            for (XSSchema schema : schemaSet.getSchemas()) {
                if (!schema.getTargetNamespace().equals(namespaceURI)) continue;
                return schemaSet;
            }
        }
        return null;
    }

    public EntityResolver getSchemaEntityResolver() {
        return this.schemaEntityResolver;
    }

    public void setSchemaEntityResolver(EntityResolver schemaEntityResolver) {
        this.schemaEntityResolver = schemaEntityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.schemaErrorHandler;
    }

    public void setErrorHandler(ErrorHandler schemaErrorHandler) {
        this.schemaErrorHandler = schemaErrorHandler;
    }

    public AnnotationParserFactory getAnnotationParser() {
        return this.annotationParserFactory;
    }

    public void setAnnotationParser(AnnotationParserFactory annotationParserFactory) {
        this.annotationParserFactory = annotationParserFactory;
    }

    public boolean registerSchemaLocation(String namespaceURI, File schemaLocation) {
        if (Modules.getModule(namespaceURI) != null) {
            return false;
        }
        if ("http://www.citygml.org/citygml/1/0/0".equals(namespaceURI)) {
            return false;
        }
        this.schemaLocations.put(namespaceURI, schemaLocation.toURI().toString());
        return true;
    }

    public void parseSchema(Element element) throws SAXException {
        String[] split;
        String schemaLocation = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocation.length() == 0) {
            schemaLocation = element.getAttribute("schemaLocation");
        }
        if (schemaLocation.length() > 0 && (split = schemaLocation.trim().split("\\s+")).length % 2 == 0) {
            for (int i = 0; i < split.length; i += 2) {
                this.parseSchema(split[i], split[i + 1]);
            }
        }
    }

    public void parseSchema(File schemaLocation) throws SAXException {
        this.parse(schemaLocation.toURI().toString());
    }

    public void parseSchema(String namespaceURI, String schemaLocation) throws SAXException {
        if (this.visited.containsKey(namespaceURI)) {
            return;
        }
        if (this.schemaLocations.containsKey(namespaceURI)) {
            schemaLocation = this.schemaLocations.get(namespaceURI);
        }
        try {
            this.parse(schemaLocation);
        }
        catch (SAXException e) {
            if (this.schemaEntityResolver != null) {
                try {
                    InputSource inputSource = this.schemaEntityResolver.resolveEntity(namespaceURI, schemaLocation);
                    if (inputSource != null) {
                        this.parse(inputSource.getSystemId());
                    }
                }
                catch (IOException io) {
                    throw new SAXException("Caused by: ", io);
                }
            }
            throw e;
        }
    }

    public void resolveAndParseSchema(String namespaceURI) throws SAXException, MissingADESchemaException {
        if (this.visited.containsKey(namespaceURI)) {
            return;
        }
        InputSource is = null;
        if (this.schemaEntityResolver != null) {
            try {
                is = this.schemaEntityResolver.resolveEntity(namespaceURI, null);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        if (is == null) {
            throw new MissingADESchemaException("Failed to resolve ADE Schema document for target namespace " + namespaceURI);
        }
        this.parse(is);
    }

    private void parse(String schemaLocation) throws SAXException {
        if (schemaLocation == null) {
            return;
        }
        this.parse(new InputSource(schemaLocation));
    }

    private void parse(InputSource is) throws SAXException {
        if (is == null) {
            return;
        }
        XSOMParser parser = new XSOMParser(this.getSAXParserFactory());
        parser.setEntityResolver((publicId, systemId) -> {
            InputSource inputSource = null;
            if (publicId != null) {
                for (Map.Entry<String, String> entry : this.visited.entrySet()) {
                    if (!entry.getKey().equals(publicId)) continue;
                    inputSource = new InputSource(entry.getValue());
                    inputSource.setPublicId(publicId);
                    inputSource.setSystemId(entry.getValue());
                    break;
                }
            }
            if (inputSource == null && publicId != null && this.schemaEntityResolver != null) {
                inputSource = this.schemaEntityResolver.resolveEntity(publicId, systemId);
            }
            return inputSource;
        });
        if (this.schemaErrorHandler != null) {
            parser.setErrorHandler(this.schemaErrorHandler);
        }
        if (this.annotationParserFactory != null) {
            parser.setAnnotationParser(this.annotationParserFactory);
        }
        parser.parse(is);
        XSSchemaSet schemaSet = parser.getResult();
        if (schemaSet != null) {
            for (XSSchema schema : schemaSet.getSchemas()) {
                Locator locator;
                if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace()) || (locator = schema.getLocator()) == null) continue;
                String systemId2 = locator.getSystemId();
                String visitedId = this.visited.get(schema.getTargetNamespace());
                if (visitedId == null) {
                    this.visited.put(schema.getTargetNamespace(), systemId2);
                    continue;
                }
                try {
                    URL cachedURL = new URL(visitedId);
                    URL offeredURL = new URL(systemId2);
                    if (cachedURL.getProtocol().equals("file") || cachedURL.getProtocol().equals("jar") || !offeredURL.getProtocol().equals("file") && !offeredURL.getProtocol().equals("jar")) continue;
                    this.visited.put(schema.getTargetNamespace(), systemId2);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            this.schemaSets.add(schemaSet);
        }
    }

    public Set<String> getTargetNamespaces() {
        return this.visited.keySet();
    }

    public int size() {
        return this.visited.size();
    }

    public boolean isEmpty() {
        return this.visited.isEmpty();
    }

    public Source[] getSchemaSources() {
        Source[] sources = new Source[this.visited.size()];
        int i = 0;
        for (String systemId : this.visited.values()) {
            sources[i++] = new StreamSource(systemId);
        }
        return sources;
    }

    public Source getSchemaSource(Schema schema) {
        String systemId = this.visited.get(schema.namespaceURI);
        if (systemId != null) {
            return new StreamSource(systemId);
        }
        return null;
    }

    public Source getSchemaSource(CityGMLModule module) {
        String systemId = this.visited.get(module.getNamespaceURI());
        if (systemId != null) {
            return new StreamSource(systemId);
        }
        return null;
    }

    private SAXParserFactory getSAXParserFactory() throws SAXException {
        if (this.saxParserFactory == null) {
            try {
                this.saxParserFactory = SAXParserFactory.newInstance();
                this.saxParserFactory.setXIncludeAware(false);
                this.saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                this.saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                this.saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                this.saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Exception e) {
                throw new SAXException("Failed to initialize secure XML schema reader.", e);
            }
        }
        return this.saxParserFactory;
    }
}

