/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.opengis.cite.citygml20.CommonFixture;
import org.opengis.cite.citygml20.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppearanceModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.2 Appearance module")
    public void verifyAppearanceModule() throws Exception {
        String moduleName;
        String SchemaPath = "xsd/opengis/citygml/appearance/2.0/appearance.xsd";
        String moduleElementName = moduleName = "Appearance";
        NodeList rootElementList = this.testSubject.getChildNodes();
        boolean foundAtLeastOne = false;
        for (int a = 0; a < rootElementList.getLength(); ++a) {
            NodeList nodeList;
            DeferredElementNSImpl element;
            if (!rootElementList.item(a).getClass().toString().equals("class org.apache.xerces.dom.DeferredElementNSImpl") || !(element = (DeferredElementNSImpl)rootElementList.item(a)).getLocalName().equals("CityModel") || !element.getNamespaceURI().equals("http://www.opengis.net/citygml/2.0") || (nodeList = element.getElementsByTagNameNS("http://www.opengis.net/citygml/" + moduleName.toLowerCase() + "/2.0", moduleElementName)).getLength() <= 0) continue;
            foundAtLeastOne = true;
        }
        Assert.assertTrue(foundAtLeastOne, "No " + moduleElementName + " element was found in the document.");
    }

    @Test(enabled=true, description="B.2.2 Appearance module - Clause 9.7 - Referential integrity 11", dependsOnMethods={"verifyAppearanceModule"})
    public void verifyAppearanceTextureCoordinatesToLinearRingId() throws Exception {
        String value;
        Element n;
        int i;
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        LinkedHashSet<String> targetSet = new LinkedHashSet<String>();
        String expressionPath = "//*[@gml:id]";
        NodeList nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            n = (Element)nodes.item(i);
            value = n.getAttribute("gml:id");
            idSet.add(value);
        }
        expressionPath = "//app:textureCoordinates[@ring]";
        nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            n = (Element)nodes.item(i);
            value = n.getAttribute("ring").substring(1);
            targetSet.add(value);
        }
        boolean state = idSet.containsAll(targetSet);
        Assert.assertTrue(state, "TextureCoordinates's attribute(ring) reference invalid.");
        targetSet.clear();
        expressionPath = "//app:GeoreferencedTexture/app:target/text()";
        nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            String value2 = nodes.item(i).getNodeValue().substring(1);
            targetSet.add(value2);
        }
        state = idSet.containsAll(targetSet);
        Assert.assertTrue(state, "GeoreferencedTexture's node(app:target) reference invalid.");
    }

    @Test(enabled=true, description="B.2.2 Appearance module - Clause 9.7. Base requirement 3", dependsOnMethods={"verifyAppearanceModule"})
    public void verifyAppearanceTextureCoordinatesToLinearRingPosList() throws Exception {
        String value;
        Element n;
        int i;
        Hashtable<String, String> textureCoordinatesTable = new Hashtable<String, String>();
        String expressionPath = "//app:textureCoordinates[@ring]";
        NodeList nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            n = (Element)nodes.item(i);
            value = n.getAttribute("ring");
            textureCoordinatesTable.put(value, n.getTextContent().trim());
        }
        expressionPath = "//gml:LinearRing";
        nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            String srsDimensionString;
            n = (Element)nodes.item(i);
            if (!n.hasAttributeNS("http://www.opengis.net/gml", "id")) continue;
            value = n.getAttributeNS("http://www.opengis.net/gml", "id");
            if (!textureCoordinatesTable.containsKey("#" + value)) continue;
            String linearRingCoordinates = ((Element)n.getElementsByTagNameNS("http://www.opengis.net/gml", "posList").item(0)).getTextContent().trim();
            int numberOfLinearRingCoordinates = linearRingCoordinates.split("\\s+").length;
            int numberOfTextureCoordinates = ((String)textureCoordinatesTable.get("#" + value)).split("\\s+").length;
            Assert.assertTrue(numberOfTextureCoordinates / 2 == numberOfLinearRingCoordinates / Integer.parseInt(srsDimensionString = ((Element)n.getElementsByTagNameNS("http://www.opengis.net/gml", "posList").item(0)).getAttribute("srsDimension")), "Problem with " + value + ". Each boundary point of the surface must receive a corresponding coordinate pair in texture space.");
        }
    }
}

