/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.opengis.cite.citygml20.CommonFixture;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.NodeList;

public class CoreModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.1 CityGML Core module")
    public void verifyCityGMLCoreModule() throws Exception {
        String moduleName = "CityGML Core";
        String SchemaPath = "xsd/opengis/citygml/2.0/cityGMLBase.xsd";
        ArrayList<String> arrayList = this.GetToValidateXsdPathArrayList(this.testSubject);
        String[] arrXsdPath = new String[arrayList.size()];
        arrayList.toArray(arrXsdPath);
        String str = this.TransformXMLDocumentToXMLString(this.testSubject);
        boolean result = this.isMultipleXMLSchemaValid(str, arrXsdPath);
        if (result) {
            NodeList rootElementList = this.testSubject.getChildNodes();
            boolean foundCityModel = false;
            for (int a = 0; a < rootElementList.getLength(); ++a) {
                DeferredElementNSImpl element;
                if (!rootElementList.item(a).getClass().toString().equals("class org.apache.xerces.dom.DeferredElementNSImpl") || !(element = (DeferredElementNSImpl)rootElementList.item(a)).getLocalName().equals("CityModel") || !element.getNamespaceURI().equals("http://www.opengis.net/citygml/2.0")) continue;
                foundCityModel = true;
            }
            Assert.assertTrue(foundCityModel, "Expected the root element to be a single CityModel element but was." + this.testSubject.getChildNodes().item(0).getNamespaceURI() + " " + this.testSubject.getChildNodes().item(0).getNodeName());
        } else {
            Assert.fail("The document failed schema validation.");
        }
    }
}

