/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.opengis.cite.citygml20.CommonFixture;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.NodeList;

public class ReliefModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.9 Relief module")
    public void verifyReliefModule() {
        String SchemaPath = "xsd/opengis/citygml/relief/2.0/relief.xsd";
        String moduleName = "Relief";
        String[] moduleElementNameList = new String[]{"ReliefFeature", "TINRelief", "MassPointRelief", "BreaklineRelief", "RasterRelief"};
        StringBuffer sb = new StringBuffer();
        for (int s2 = 0; s2 < moduleElementNameList.length; ++s2) {
            sb.append(moduleElementNameList[s2]);
            if (s2 < moduleElementNameList.length - 1) {
                sb.append(", ");
                continue;
            }
            sb.append(" ");
        }
        NodeList rootElementList = this.testSubject.getChildNodes();
        boolean foundAtLeastOne = false;
        for (int a = 0; a < rootElementList.getLength(); ++a) {
            DeferredElementNSImpl element;
            if (!rootElementList.item(a).getClass().toString().equals("class org.apache.xerces.dom.DeferredElementNSImpl") || !(element = (DeferredElementNSImpl)rootElementList.item(a)).getLocalName().equals("CityModel") || !element.getNamespaceURI().equals("http://www.opengis.net/citygml/2.0")) continue;
            for (int b = 0; b < moduleElementNameList.length; ++b) {
                NodeList nodeList = element.getElementsByTagNameNS("http://www.opengis.net/citygml/" + moduleName.toLowerCase() + "/2.0", moduleElementNameList[b]);
                if (nodeList.getLength() <= 0) continue;
                foundAtLeastOne = true;
            }
        }
        Assert.assertTrue(foundAtLeastOne, "None of " + sb.toString() + " elements was found in the document.");
    }
}

