/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import org.opengis.cite.citygml20.CommonFixture;
import org.opengis.cite.citygml20.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WaterBodyModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.13 WaterBody module")
    public void verifyWaterBodyModule() throws Exception {
        String moduleName = "WaterBody";
        String SchemaPath = "xsd/opengis/citygml/waterbody/2.0/waterBody.xsd";
        if (!this.docNameSpace.contains(SchemaPath)) {
            throw new SkipException("Not " + moduleName + " module.");
        }
        boolean validParent = true;
        String[] WaterBoundarySurfaceTypes = new String[]{"WaterSurface", "WaterGroundSurface", "WaterClosureSurface"};
        String prefix = "//*/wtr:";
        block0: for (int indexType = 0; indexType < WaterBoundarySurfaceTypes.length; ++indexType) {
            String expressionPath = prefix + WaterBoundarySurfaceTypes[indexType];
            NodeList nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element n = (Element)nodes.item(i);
                Node parentNode = n.getParentNode();
                String parentNodeName = parentNode.getNodeName();
                if (parentNodeName.equals("wtr:WaterBody")) continue;
                validParent = false;
                continue block0;
            }
        }
        Assert.assertTrue(validParent, "_WaterBoundarySurface elements shall only be included as parts of corresponding WaterBody elements.");
    }
}

