/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ArrayIterator;
import org.testng.internal.ClassHelper;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodHelper {
    private static final Map<ITestNGMethod[], Graph<ITestNGMethod>> GRAPH_CACHE = new ConcurrentHashMap<ITestNGMethod[], Graph<ITestNGMethod>>();
    private static final Map<Method, String> CANONICAL_NAME_CACHE = new ConcurrentHashMap<Method, String>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        List<ITestNGMethod> includedMethods = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup(methods.toArray(new ITestNGMethod[methods.size()]), forTests, includedMethods, outExcludedMethods, runInfo, finder, unique);
        return MethodHelper.sortMethods(forTests, includedMethods, finder).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod m3, ITestNGMethod[] methods) {
        String canonicalMethodName = MethodHelper.calculateMethodCanonicalName(m3);
        List vResult = Lists.newArrayList();
        String regexp = null;
        for (String fullyQualifiedRegexp : m3.getMethodsDependedUpon()) {
            boolean foundAtLeastAMethod = false;
            if (null != fullyQualifiedRegexp) {
                regexp = fullyQualifiedRegexp.replace("$", "\\$");
                boolean usePackage = regexp.indexOf(46) != -1;
                Pattern pattern = Pattern.compile(regexp);
                for (ITestNGMethod method : methods) {
                    Method thisMethod = method.getMethod();
                    String thisMethodName = thisMethod.getName();
                    String methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(thisMethod) : thisMethodName;
                    Pair<String, String> cacheKey = Pair.create(regexp, methodName);
                    Boolean match = MATCH_CACHE.get(cacheKey);
                    if (match == null) {
                        match = pattern.matcher(methodName).matches();
                        MATCH_CACHE.put(cacheKey, match);
                    }
                    if (!match.booleanValue()) continue;
                    vResult.add(method);
                    foundAtLeastAMethod = true;
                }
            }
            if (foundAtLeastAMethod || m3.ignoreMissingDependencies() || m3.isAlwaysRun()) continue;
            Method maybeReferringTo = MethodHelper.findMethodByName(m3, regexp);
            if (maybeReferringTo != null) {
                throw new TestNGException(canonicalMethodName + "() is depending on method " + maybeReferringTo + ", which is not annotated with @Test or not included.");
            }
            throw new TestNGException(canonicalMethodName + "() depends on nonexistent method " + regexp);
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    private static Method findMethodByName(ITestNGMethod testngMethod, String regExp) {
        String methodName;
        String className;
        if (regExp == null) {
            return null;
        }
        int lastDot = regExp.lastIndexOf(46);
        if (lastDot == -1) {
            className = testngMethod.getMethod().getDeclaringClass().getCanonicalName();
            methodName = regExp;
        } else {
            methodName = regExp.substring(lastDot + 1);
            className = regExp.substring(0, lastDot);
        }
        try {
            Class<?> c = Class.forName(className);
            for (Method m3 : c.getDeclaredMethods()) {
                if (!methodName.equals(m3.getName())) continue;
                return m3;
            }
        }
        catch (Exception e) {
            Utils.log("MethodHelper", 3, "Caught exception while searching for methods using regex");
        }
        return null;
    }

    protected static boolean isEnabled(Class<?> objectClass, IAnnotationFinder finder) {
        ITestAnnotation testClassAnnotation = AnnotationHelper.findTest(finder, objectClass);
        return MethodHelper.isEnabled(testClassAnnotation);
    }

    protected static boolean isEnabled(Method m3, IAnnotationFinder finder) {
        ITestAnnotation annotation2 = AnnotationHelper.findTest(finder, m3);
        if (null == annotation2) {
            annotation2 = AnnotationHelper.findTest(finder, m3.getDeclaringClass());
        }
        return MethodHelper.isEnabled(annotation2);
    }

    protected static boolean isEnabled(ITestOrConfiguration test) {
        return null == test || test.getEnabled();
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> methods) {
        Set resultSet = Sets.newHashSet();
        for (List<ITestNGMethod> l : methods) {
            resultSet.addAll(l);
        }
        return Lists.newArrayList(resultSet);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        Graph<ITestNGMethod> result = new Graph<ITestNGMethod>();
        if (methods.length == 0) {
            return result;
        }
        for (ITestNGMethod m3 : methods) {
            result.addNode(m3);
            List<ITestNGMethod> predecessors = Lists.newArrayList();
            String[] methodsDependedUpon = m3.getMethodsDependedUpon();
            String[] groupsDependedUpon = m3.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                ITestNGMethod[] iTestNGMethodArray = methodsNamed = MethodHelper.findDependedUponMethods(m3, methods);
                int n = iTestNGMethodArray.length;
                for (int i = 0; i < n; ++i) {
                    ITestNGMethod pred = iTestNGMethodArray[i];
                    predecessors.add(pred);
                }
            }
            if (groupsDependedUpon.length > 0) {
                for (String group2 : groupsDependedUpon) {
                    ITestNGMethod[] methodsThatBelongToGroup;
                    for (ITestNGMethod pred : methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup(m3, methods, group2)) {
                        predecessors.add(pred);
                    }
                }
            }
            for (ITestNGMethod predecessor : predecessors) {
                result.addPredecessor(m3, predecessor);
            }
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod m3) {
        return MethodHelper.calculateMethodCanonicalName(m3.getMethod());
    }

    private static String calculateMethodCanonicalName(Method m3) {
        String result = CANONICAL_NAME_CACHE.get(m3);
        if (result != null) {
            return result;
        }
        String packageName = m3.getDeclaringClass().getName() + "." + m3.getName();
        for (Class<?> cls = m3.getDeclaringClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                if (cls.getDeclaredMethod(m3.getName(), m3.getParameterTypes()) == null) continue;
                packageName = cls.getName();
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        result = packageName + "." + m3.getName();
        CANONICAL_NAME_CACHE.put(m3, result);
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, IAnnotationFinder finder) {
        List<ITestNGMethod> sl = Lists.newArrayList();
        List<ITestNGMethod> pl = Lists.newArrayList();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[allMethods.size()]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m3 = allMethodsArray[0];
            boolean before = m3.isBeforeClassConfiguration() || m3.isBeforeMethodConfiguration() || m3.isBeforeSuiteConfiguration() || m3.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(allMethodsArray, before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl);
        List<ITestNGMethod> result = Lists.newArrayList();
        result.addAll(sl);
        result.addAll(pl);
        return result;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods) {
        Graph<ITestNGMethod> g2 = GRAPH_CACHE.get(methods);
        if (g2 == null) {
            List<ITestNGMethod> parallelList = Lists.newArrayList();
            List<ITestNGMethod> sequentialList = Lists.newArrayList();
            g2 = MethodHelper.topologicalSort(methods, sequentialList, parallelList);
            GRAPH_CACHE.put(methods, g2);
        }
        List<ITestNGMethod> result = g2.findPredecessors(method);
        return result;
    }

    protected static Iterator<Object[]> createArrayIterator(Object[][] objects) {
        ArrayIterator result = new ArrayIterator(objects);
        return result;
    }

    protected static String calculateMethodCanonicalName(Class<?> methodClass, String methodName) {
        Set<Method> methods = ClassHelper.getAvailableMethods(methodClass);
        Method result = null;
        for (Method m3 : methods) {
            if (!methodName.equals(m3.getName())) continue;
            result = m3;
            break;
        }
        return result != null ? MethodHelper.calculateMethodCanonicalName(result) : null;
    }

    protected static long calculateTimeOut(ITestNGMethod tm) {
        long result = tm.getTimeOut() > 0L ? tm.getTimeOut() : tm.getInvocationTimeOut();
        return result;
    }
}

