/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Collections;
import java.util.List;
import org.testng.ISuite;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class GroupPanel
extends BaseMultiSuitePanel {
    public GroupPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "group-";
    }

    @Override
    public String getHeader(ISuite suite) {
        return "Groups for " + suite.getName();
    }

    @Override
    public String getContent(ISuite suite, XMLStringBuffer main) {
        XMLStringBuffer xsb = new XMLStringBuffer(main.getCurrentIndent());
        List<String> sortedGroups = this.getModel().getGroups(suite.getName());
        Collections.sort(sortedGroups);
        for (String group2 : sortedGroups) {
            xsb.push("div", "class", "test-group");
            xsb.addRequired("span", group2, "class", "test-group-name");
            xsb.addEmptyElement("br");
            List<String> sortedMethods = this.getModel().getMethodsInGroup(group2);
            for (String method : sortedMethods) {
                xsb.push("div", "class", "method-in-group");
                xsb.addRequired("span", method, "class", "method-in-group-name");
                xsb.addEmptyElement("br");
                xsb.pop("div");
            }
            xsb.pop("div");
        }
        return xsb.toXML();
    }

    @Override
    public String getNavigatorLink(ISuite suite) {
        return GroupPanel.pluralize(this.getModel().getGroups(suite.getName()).size(), "group");
    }
}

