/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.collections.Pair;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.dom.ITagFactory;
import org.testng.xml.dom.ITagSetter;
import org.testng.xml.dom.ParentSetter;
import org.testng.xml.dom.Reflect;
import org.testng.xml.dom.TagContent;
import org.testng.xml.dom.TestNGTagFactory;
import org.testng.xml.dom.Wrapper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XDom {
    private Document m_document;
    private ITagFactory m_tagFactory;

    public XDom(ITagFactory tagFactory, Document document) throws XPathExpressionException, InstantiationException, IllegalAccessException {
        this.m_tagFactory = tagFactory;
        this.m_document = document;
    }

    public Object parse() throws XPathExpressionException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object result = null;
        NodeList nodes = this.m_document.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (item.getAttributes() == null) continue;
            String nodeName = item.getNodeName();
            System.out.println("Node name:" + nodeName);
            Class<?> c = this.m_tagFactory.getClassForTag(nodeName);
            if (c == null) {
                throw new RuntimeException("No class found for tag " + nodeName);
            }
            result = c.newInstance();
            this.populateAttributes(item, result);
            if (ITagSetter.class.isAssignableFrom(result.getClass())) {
                throw new RuntimeException("TAG SETTER");
            }
            this.populateChildren(item, result);
        }
        return result;
    }

    public void populateChildren(Node root, Object result) throws InstantiationException, IllegalAccessException, XPathExpressionException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        this.p("populateChildren: " + root.getLocalName());
        NodeList childNodes = root.getChildNodes();
        ListMultiMap<String, Object> children = Maps.newListMultiMap();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Class<?> c;
            Node item = childNodes.item(i);
            if (item.getAttributes() == null) continue;
            String nodeName = item.getNodeName();
            if ("suite-files".equals(nodeName)) {
                System.out.println("BREAK");
            }
            if ((c = this.m_tagFactory.getClassForTag(nodeName)) == null) {
                System.out.println("Warning: No class found for tag " + nodeName);
                boolean foundSetter = this.invokeOnSetter(result, (Element)item, nodeName, null);
                System.out.println("  found setter:" + foundSetter);
                continue;
            }
            Object object = this.instantiateElement(c, result);
            if (ITagSetter.class.isAssignableFrom(object.getClass())) {
                System.out.println("Tag setter:" + result);
                ((ITagSetter)object).setProperty(nodeName, result, item);
            } else {
                children.put(nodeName, object);
                this.populateAttributes(item, object);
                this.populateContent(item, object);
            }
            boolean foundSetter = this.invokeOnSetter(result, (Element)item, nodeName, object);
            this.populateChildren(item, object);
        }
    }

    private Object instantiateElement(Class<?> c, Object parent) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        Method m3 = this.findMethodAnnotatedWith(c, ParentSetter.class);
        if (m3 != null) {
            result = c.newInstance();
            m3.invoke(result, parent);
        } else {
            try {
                result = c.getConstructor(parent.getClass()).newInstance(parent);
            }
            catch (NoSuchMethodException ex) {
                result = c.newInstance();
            }
        }
        return result;
    }

    private Method findMethodAnnotatedWith(Class<?> c, Class<? extends Annotation> annotation2) {
        for (Method m3 : c.getMethods()) {
            if (m3.getAnnotation(annotation2) == null) continue;
            return m3;
        }
        return null;
    }

    private void populateContent(Node item, Object object) {
        for (int i = 0; i < item.getChildNodes().getLength(); ++i) {
            Node child = item.getChildNodes().item(i);
            if (!(child instanceof Text)) continue;
            this.setText(object, (Text)child);
        }
    }

    private void setText(Object bean, Text child) {
        List<Pair<Method, Wrapper>> pairs = Reflect.findMethodsWithAnnotation(bean.getClass(), TagContent.class, bean);
        for (Pair<Method, Wrapper> pair : pairs) {
            try {
                pair.first().invoke(bean, child.getTextContent());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | DOMException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean invokeOnSetter(Object object, Element element, String nodeName, Object bean) {
        Pair<Method, Wrapper> pair = Reflect.findSetterForTag(object.getClass(), nodeName, bean);
        List<Object> allParameters = null;
        if (pair != null) {
            Method m3 = pair.first();
            try {
                if (pair.second() != null) {
                    allParameters = pair.second().getParameters(element);
                } else {
                    allParameters = Lists.newArrayList();
                    allParameters.add(new Object[]{bean});
                }
                for (Object[] objectArray : allParameters) {
                    m3.invoke(object, objectArray);
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                System.out.println("Parameters: " + allParameters);
                e.printStackTrace();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void populateAttributes(Node node, Object object) throws XPathExpressionException {
        for (int j = 0; j < node.getAttributes().getLength(); ++j) {
            Node item = node.getAttributes().item(j);
            this.setProperty(object, item.getLocalName(), item.getNodeValue());
        }
    }

    private void setProperty(Object object, String name, Object value) {
        block6: {
            Pair<Method, Wrapper> setter = Reflect.findSetterForTag(object.getClass(), name, value);
            if (setter != null) {
                Method foundMethod = setter.first();
                try {
                    Class<?> type = foundMethod.getParameterTypes()[0];
                    if (type == Boolean.class || type == Boolean.TYPE) {
                        foundMethod.invoke(object, Boolean.parseBoolean(value.toString()));
                        break block6;
                    }
                    if (type == Integer.class || type == Integer.TYPE) {
                        foundMethod.invoke(object, Integer.parseInt(value.toString()));
                        break block6;
                    }
                    foundMethod.invoke(object, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                this.e("Couldn't find setter method for property" + name + " on " + object.getClass());
            }
        }
    }

    private void p(String string) {
        System.out.println("[XDom] " + string);
    }

    private void e(String string) {
        System.out.println("[XDom] [Error] " + string);
    }

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        FileInputStream inputStream = new FileInputStream(new File(System.getProperty("user.home") + "/java/testng/src/test/resources/testng-all.xml"));
        Document doc = builder.parse(inputStream);
        XmlSuite result = (XmlSuite)new XDom(new TestNGTagFactory(), doc).parse();
        XDom.test(result);
        System.out.println(result.toXml());
    }

    private static void test(XmlSuite s2) {
        Assert.assertEquals("TestNG", s2.getName());
        Assert.assertEquals(s2.getDataProviderThreadCount(), 3);
        Assert.assertEquals(s2.getThreadCount(), 2);
        List<XmlMethodSelector> selectors = s2.getMethodSelectors();
        Assert.assertEquals(selectors.size(), 2);
        XmlMethodSelector s1 = selectors.get(0);
        Assert.assertEquals(s1.getLanguage(), "javascript");
        Assert.assertEquals(s1.getExpression(), "foo()");
        XmlMethodSelector s22 = selectors.get(1);
        Assert.assertEquals(s22.getClassName(), "SelectorClass");
        Assert.assertEquals(s22.getPriority(), 3);
        List<String> suiteFiles = s2.getSuiteFiles();
        Assert.assertEquals(suiteFiles, Arrays.asList("./junit-suite.xml"));
        Map<String, String> p = s2.getParameters();
        Assert.assertEquals(p.size(), 2);
        Assert.assertEquals(p.get("suiteParameter"), "suiteParameterValue");
        Assert.assertEquals(p.get("first-name"), "Cedric");
        Assert.assertEquals(s2.getIncludedGroups(), Arrays.asList("includeThisGroup"));
        Assert.assertEquals(s2.getExcludedGroups(), Arrays.asList("excludeThisGroup"));
        XmlGroups groups = s2.getGroups();
        List<XmlDefine> defines = groups.getDefines();
        Assert.assertEquals(defines.size(), 1);
        XmlDefine define = defines.get(0);
        Assert.assertEquals(define.getName(), "bigSuite");
        Assert.assertEquals(define.getIncludes(), Arrays.asList("suite1", "suite2"));
        Assert.assertEquals(s2.getPackageNames(), Arrays.asList("com.example1", "com.example2"));
        Assert.assertEquals(s2.getListeners(), Arrays.asList("com.beust.Listener1", "com.beust.Listener2"));
        Assert.assertEquals(s2.getTests().size(), 3);
        for (int i = 0; i < s2.getTests().size(); ++i) {
            if (!"Nopackage".equals(s2.getTests().get(i).getName())) continue;
            XDom.testNoPackage(s2.getTests().get(i));
        }
    }

    private static void testNoPackage(XmlTest t) {
        Assert.assertEquals(t.getThreadCount(), 42);
        Assert.assertTrue(t.getAllowReturnValues());
        Map<String, List<String>> metaGroups = t.getMetaGroups();
        Assert.assertEquals((Collection)metaGroups.get("evenodd"), Arrays.asList("even", "odd"));
        Assert.assertEquals(t.getIncludedGroups(), Arrays.asList("nopackage", "includeThisGroup"));
        Assert.assertEquals(t.getExcludedGroups(), Arrays.asList("excludeThisGroup"));
        Map<String, String> dg = t.getXmlDependencyGroups();
        Assert.assertEquals(dg.size(), 2);
        Assert.assertEquals(dg.get("e"), "f");
        Assert.assertEquals(dg.get("g"), "h");
    }
}

