/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.core;

import java.util.ArrayList;
import org.opengis.cite.citygml20.CommonFixture;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoreValidation
extends CommonFixture {
    @Test(enabled=true, description="B.1.1 Valid CityGML instance document")
    public void verifyCityGMLinstanceDoc() throws Exception {
        ArrayList<String> arrayList = this.GetToValidateXsdPathArrayList(this.testSubject);
        arrayList.add("xsd/opengis/citygml/2.0/cityGMLBase.xsd");
        String[] arrXsdPath = new String[arrayList.size()];
        arrayList.toArray(arrXsdPath);
        String str = this.TransformXMLDocumentToXMLString(this.testSubject);
        boolean result = this.isMultipleXMLSchemaValid(str, arrXsdPath);
        Assert.assertTrue((boolean)result, (String)"Invalid CityGML Instance Document");
    }

    @Test(enabled=true, description="B.1.4 Spatial geometry objects")
    public void verifySpatialGeometryObjects() throws Exception {
        ArrayList<String> arrayList = this.getValidateSpatialGeometryArrayList();
        String[] arrXsdPath = new String[arrayList.size()];
        arrayList.toArray(arrXsdPath);
        String str = this.TransformXMLDocumentToXMLString(this.testSubject);
        boolean result = this.isMultipleXMLSchemaValid(str, arrXsdPath);
        Assert.assertTrue((boolean)result, (String)"Spatial geometry objects are invalid.");
    }

    @Test(enabled=true, description="B.1.5 Spatial topology relations")
    public void verifySpatialtopologyRelations() throws Exception {
        String id;
        ArrayList<String> arrayList = this.getValidateSpatialGeometryArrayList();
        arrayList.add("xsd/opengis/xlink/1.0/xlink-1.0.xsd");
        String[] arrXsdPath = new String[arrayList.size()];
        arrayList.toArray(arrXsdPath);
        String str = this.TransformXMLDocumentToXMLString(this.testSubject);
        boolean result = this.isMultipleXMLSchemaValid(str, arrXsdPath);
        Assert.assertTrue((boolean)result, (String)"Spatial topology relations are invalid.(xml)");
        NodeList geometryList = this.testSubject.getElementsByTagName("*");
        ArrayList<String> idArrayList = new ArrayList<String>();
        ArrayList<String> hrefArrayList = new ArrayList<String>();
        for (int i = 0; i < geometryList.getLength(); ++i) {
            Element geometryElement = (Element)geometryList.item(i);
            if (geometryElement.hasAttributeNS("http://www.opengis.net/gml", "id")) {
                id = geometryElement.getAttributeNS("http://www.opengis.net/gml", "id");
                idArrayList.add(id);
            }
            if (!geometryElement.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) continue;
            String hrefId = geometryElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
            hrefArrayList.add(hrefId);
        }
        for (String hrefId : hrefArrayList) {
            id = hrefId.replace("#", "");
            if (idArrayList.contains(id)) continue;
            Assert.assertTrue((boolean)result, (String)"Spatial topology relations are invalid.(xlink)");
        }
    }

    @Test(enabled=true, description="B.1.6 Valid Address objects")
    public void verifyAddressObject() throws Exception {
        ArrayList<String> arrayList = this.GetToValidateXsdPathArrayList(this.testSubject);
        arrayList.add("xsd/opengis/citygml/xAL/xAL.xsd");
        String[] arrXsdPath = new String[arrayList.size()];
        arrayList.toArray(arrXsdPath);
        String str = this.TransformXMLDocumentToXMLString(this.testSubject);
        boolean result = this.isMultipleXMLSchemaValid(str, arrXsdPath);
        Assert.assertTrue((boolean)result, (String)"Invalid CityGML Instance Document");
    }

    private ArrayList<String> getValidateSpatialGeometryArrayList() {
        ArrayList<String> arrayList = this.GetToValidateXsdPathArrayList(this.testSubject);
        arrayList.add("xsd/opengis/gml/3.1.1/base/gml.xsd");
        return arrayList;
    }
}

