/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.opengis.cite.citygml20.CommonFixture;
import org.opengis.cite.citygml20.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CityObjectGroupModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.6 CityObjectGroup module")
    public void verifyCityObjectGroupModule() throws Exception {
        String moduleName;
        String SchemaPath = "xsd/opengis/citygml/cityobjectgroup/2.0/cityObjectGroup.xsd";
        String moduleElementName = moduleName = "CityObjectGroup";
        NodeList rootElementList = this.testSubject.getChildNodes();
        boolean foundAtLeastOne = false;
        for (int a = 0; a < rootElementList.getLength(); ++a) {
            NodeList nodeList;
            DeferredElementNSImpl element;
            if (!rootElementList.item(a).getClass().toString().equals("class org.apache.xerces.dom.DeferredElementNSImpl") || !(element = (DeferredElementNSImpl)rootElementList.item(a)).getLocalName().equals("CityModel") || !element.getNamespaceURI().equals("http://www.opengis.net/citygml/2.0") || (nodeList = element.getElementsByTagNameNS("http://www.opengis.net/citygml/" + moduleName.toLowerCase() + "/2.0", moduleElementName)).getLength() <= 0) continue;
            foundAtLeastOne = true;
        }
        Assert.assertTrue((boolean)foundAtLeastOne, (String)("No " + moduleElementName + " element was found in the document."));
    }

    @Test(enabled=true, description="B.2.6 CityObjectGroup module - Clause 10.11.3 Base requirement 1")
    public void verifyCityObjectGroupCheckCyclicState() throws Exception {
        String moduleName = "CityObjectGroup";
        String SchemaPath = "xsd/opengis/citygml/cityobjectgroup/2.0/cityObjectGroup.xsd";
        if (!this.docNameSpace.contains(SchemaPath)) {
            throw new SkipException("Not " + moduleName + " module.");
        }
        boolean cyclingState = true;
        String cityObjectGroupExpression = "//grp:CityObjectGroup[@gml:id]/grp:groupMember";
        XPath xpath = XMLUtils.getXPathWithNS(this.testSubject);
        NodeList nodes = (NodeList)xpath.evaluate(cityObjectGroupExpression, this.testSubject, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeEl = (Element)nodes.item(i);
            Element parentEl = (Element)nodeEl.getParentNode();
            String parentId = parentEl.getAttribute("gml:id");
            String expr = "grp:CityObjectGroup";
            NodeList groupList = (NodeList)xpath.evaluate(expr, nodeEl, XPathConstants.NODESET);
            int a = groupList.getLength();
            for (int j = 0; j < groupList.getLength(); ++j) {
                Element node = (Element)groupList.item(i);
                String childId = node.getAttribute("gml:id");
                if (!childId.equals(parentId)) continue;
                cyclingState = false;
            }
        }
        Assert.assertTrue((boolean)cyclingState, (String)"No cyclic groupings shall be included within a CityGML instance document.");
    }
}

