/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.appearance.AppearanceType;
import org.citygml4j.cityjson.extension.ExtensionType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.GeometryTemplatesType;
import org.citygml4j.cityjson.geometry.TransformType;
import org.citygml4j.cityjson.geometry.VerticesList;
import org.citygml4j.cityjson.metadata.MetadataType;
import org.citygml4j.cityjson.util.PropertyHelper;

public class CityJSONAdapter
extends TypeAdapter<CityJSON> {
    private final Gson gson;
    private final CityJSONRegistry registry = CityJSONRegistry.getInstance();
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private List<String> predefinedProperties;

    public CityJSONAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, CityJSON value) throws IOException {
        if (value != null) {
            out.beginObject();
            out.name("type");
            out.value(value.getType());
            out.name("version");
            out.value(value.getVersion());
            if (value.metadata != null) {
                out.name("metadata");
                Streams.write((JsonElement)this.gson.toJsonTree((Object)value.metadata, MetadataType.class), (JsonWriter)out);
            }
            if (value.extensions != null) {
                out.name("extensions");
                Streams.write((JsonElement)this.gson.toJsonTree(value.extensions, new TypeToken<Map<String, ExtensionType>>(){}.getType()), (JsonWriter)out);
            }
            if (value.isSetExtensionProperties()) {
                JsonObject properties = this.gson.toJsonTree(value.getExtensionProperties()).getAsJsonObject();
                for (Map.Entry entry : properties.entrySet()) {
                    out.name((String)entry.getKey());
                    Streams.write((JsonElement)((JsonElement)entry.getValue()), (JsonWriter)out);
                }
            }
            if (value.cityObjects != null) {
                out.name("CityObjects");
                Streams.write((JsonElement)this.gson.toJsonTree(value.cityObjects, new TypeToken<Map<String, AbstractCityObjectType>>(){}.getType()), (JsonWriter)out);
            }
            if (value.vertices != null) {
                out.name("vertices");
                Streams.write((JsonElement)this.gson.toJsonTree((Object)value.vertices, VerticesList.class), (JsonWriter)out);
            }
            if (value.transform != null) {
                out.name("transform");
                Streams.write((JsonElement)this.gson.toJsonTree((Object)value.transform, TransformType.class), (JsonWriter)out);
            }
            if (value.appearance != null) {
                out.name("appearance");
                Streams.write((JsonElement)this.gson.toJsonTree((Object)value.appearance, AppearanceType.class), (JsonWriter)out);
            }
            if (value.geometryTemplates != null) {
                out.name("geometry-templates");
                Streams.write((JsonElement)this.gson.toJsonTree((Object)value.geometryTemplates, GeometryTemplatesType.class), (JsonWriter)out);
            }
            out.endObject();
        } else {
            out.nullValue();
        }
    }

    public CityJSON read(JsonReader in) throws IOException {
        CityJSON cityJSON = null;
        if (this.predefinedProperties == null) {
            this.predefinedProperties = this.propertyHelper.getDeclaredProperties(CityJSON.class);
        }
        if (in.peek() != JsonToken.NULL) {
            cityJSON = new CityJSON();
            in.beginObject();
            block18: while (in.hasNext()) {
                String key;
                switch (key = in.nextName()) {
                    case "metadata": {
                        cityJSON.metadata = (MetadataType)this.gson.fromJson(in, MetadataType.class);
                        continue block18;
                    }
                    case "extensions": {
                        cityJSON.extensions = (Map)this.gson.fromJson(in, new TypeToken<Map<String, ExtensionType>>(){}.getType());
                        continue block18;
                    }
                    case "CityObjects": {
                        cityJSON.cityObjects = (Map)this.gson.fromJson(in, new TypeToken<Map<String, AbstractCityObjectType>>(){}.getType());
                        continue block18;
                    }
                    case "vertices": {
                        cityJSON.vertices = (VerticesList)this.gson.fromJson(in, VerticesList.class);
                        continue block18;
                    }
                    case "transform": {
                        cityJSON.transform = (TransformType)this.gson.fromJson(in, TransformType.class);
                        continue block18;
                    }
                    case "appearance": {
                        cityJSON.appearance = (AppearanceType)this.gson.fromJson(in, AppearanceType.class);
                        continue block18;
                    }
                    case "geometry-templates": {
                        cityJSON.geometryTemplates = (GeometryTemplatesType)this.gson.fromJson(in, GeometryTemplatesType.class);
                        continue block18;
                    }
                }
                if (!this.predefinedProperties.contains(key)) {
                    Type extensionAttributeType = this.registry.getExtensionPropertyClass(key, cityJSON);
                    Object value = extensionAttributeType != null ? this.gson.fromJson(in, extensionAttributeType) : this.propertyHelper.deserialize(Streams.parse((JsonReader)in));
                    if (value == null) continue;
                    cityJSON.addExtensionProperty(key, value);
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
        }
        return cityJSON;
    }
}

