/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.extension.ExtensionException;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.BridgeConstructionElementType;
import org.citygml4j.cityjson.feature.BridgeInstallationType;
import org.citygml4j.cityjson.feature.BridgePartType;
import org.citygml4j.cityjson.feature.BridgeType;
import org.citygml4j.cityjson.feature.BuildingInstallationType;
import org.citygml4j.cityjson.feature.BuildingPartType;
import org.citygml4j.cityjson.feature.BuildingType;
import org.citygml4j.cityjson.feature.CityFurnitureType;
import org.citygml4j.cityjson.feature.CityObjectGroupType;
import org.citygml4j.cityjson.feature.GenericCityObjectType;
import org.citygml4j.cityjson.feature.LandUseType;
import org.citygml4j.cityjson.feature.PlantCoverType;
import org.citygml4j.cityjson.feature.RailwayType;
import org.citygml4j.cityjson.feature.RoadType;
import org.citygml4j.cityjson.feature.SolitaryVegetationObjectType;
import org.citygml4j.cityjson.feature.TINReliefType;
import org.citygml4j.cityjson.feature.TransportSquareType;
import org.citygml4j.cityjson.feature.TunnelInstallationType;
import org.citygml4j.cityjson.feature.TunnelPartType;
import org.citygml4j.cityjson.feature.TunnelType;
import org.citygml4j.cityjson.feature.WaterBodyType;
import org.citygml4j.cityjson.geometry.InternalSemanticsType;
import org.citygml4j.cityjson.geometry.SemanticsType;

public class CityJSONRegistry {
    private static CityJSONRegistry instance;
    private final Map<String, Class<? extends AbstractCityObjectType>> types = new ConcurrentHashMap<String, Class<? extends AbstractCityObjectType>>();
    private final Map<String, Class<? extends SemanticsType>> semanticSurfaces = new ConcurrentHashMap<String, Class<? extends SemanticsType>>();
    private final Map<Class<? extends ExtensibleType>, Map<String, Type>> properties = new ConcurrentHashMap<Class<? extends ExtensibleType>, Map<String, Type>>();
    private final Set<String> coreTypes;

    private CityJSONRegistry() {
        this.types.put("Building", BuildingType.class);
        this.types.put("BuildingPart", BuildingPartType.class);
        this.types.put("BuildingInstallation", BuildingInstallationType.class);
        this.types.put("Bridge", BridgeType.class);
        this.types.put("BridgePart", BridgePartType.class);
        this.types.put("BridgeInstallation", BridgeInstallationType.class);
        this.types.put("BridgeConstructionElement", BridgeConstructionElementType.class);
        this.types.put("TINRelief", TINReliefType.class);
        this.types.put("WaterBody", WaterBodyType.class);
        this.types.put("PlantCover", PlantCoverType.class);
        this.types.put("SolitaryVegetationObject", SolitaryVegetationObjectType.class);
        this.types.put("LandUse", LandUseType.class);
        this.types.put("CityFurniture", CityFurnitureType.class);
        this.types.put("GenericCityObject", GenericCityObjectType.class);
        this.types.put("Road", RoadType.class);
        this.types.put("Railway", RailwayType.class);
        this.types.put("TransportSquare", TransportSquareType.class);
        this.types.put("Tunnel", TunnelType.class);
        this.types.put("TunnelPart", TunnelPartType.class);
        this.types.put("TunnelInstallation", TunnelInstallationType.class);
        this.types.put("CityObjectGroup", CityObjectGroupType.class);
        this.semanticSurfaces.put("RoofSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("GroundSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("WallSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("ClosureSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("OuterCeilingSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("OuterFloorSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("Window", InternalSemanticsType.class);
        this.semanticSurfaces.put("Door", InternalSemanticsType.class);
        this.semanticSurfaces.put("TrafficArea", InternalSemanticsType.class);
        this.semanticSurfaces.put("AuxiliaryTrafficArea", InternalSemanticsType.class);
        this.semanticSurfaces.put("WaterSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("WaterGroundSurface", InternalSemanticsType.class);
        this.semanticSurfaces.put("WaterClosureSurface", InternalSemanticsType.class);
        this.coreTypes = new HashSet<String>(this.types.keySet());
    }

    public static synchronized CityJSONRegistry getInstance() {
        if (instance == null) {
            instance = new CityJSONRegistry();
        }
        return instance;
    }

    public boolean isCoreCityObject(String type) {
        return this.coreTypes.contains(type);
    }

    public String getCityObjectType(AbstractCityObjectType cityObject) {
        String type = null;
        for (Map.Entry<String, Class<? extends AbstractCityObjectType>> entry : this.types.entrySet()) {
            if (cityObject.getClass() != entry.getValue()) continue;
            type = entry.getKey();
            break;
        }
        if (type == null) {
            type = cityObject.getClass().getTypeName();
        }
        return type;
    }

    public Class<? extends AbstractCityObjectType> getCityObjectClass(String type) {
        Class<? extends AbstractCityObjectType> typeClass = this.types.get(type);
        if (typeClass == null) {
            try {
                Class<?> tmp = Class.forName(type);
                if (AbstractCityObjectType.class.isAssignableFrom(tmp)) {
                    typeClass = tmp.asSubclass(AbstractCityObjectType.class);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return typeClass;
    }

    public void registerCityObject(String type, Class<? extends AbstractCityObjectType> typeClass) throws ExtensionException {
        if (type == null) {
            throw new ExtensionException("The city object type must not be null.");
        }
        if (typeClass == null) {
            throw new ExtensionException("The city object type class must not be null.");
        }
        if (this.types.containsKey(type)) {
            throw new ExtensionException("The city object type '" + type + "' is already registered.");
        }
        if (this.types.containsValue(typeClass)) {
            throw new ExtensionException("The city object type class '" + typeClass.getTypeName() + "' is already registered.");
        }
        this.types.put(type, typeClass);
    }

    public void unregisterCityObject(String type) {
        this.types.remove(type);
    }

    public String getSemanticSurfaceType(SemanticsType semanticsType) {
        String type = null;
        for (Map.Entry<String, Class<? extends SemanticsType>> entry : this.semanticSurfaces.entrySet()) {
            if (semanticsType.getClass() != entry.getValue()) continue;
            type = entry.getKey();
            break;
        }
        if (type == null) {
            type = semanticsType.getClass().getTypeName();
        }
        return type;
    }

    public Class<? extends SemanticsType> getSemanticSurfaceClass(String type) {
        Class<? extends SemanticsType> typeClass = this.semanticSurfaces.get(type);
        if (typeClass == null) {
            try {
                Class<?> tmp = Class.forName(type);
                if (SemanticsType.class.isAssignableFrom(tmp)) {
                    typeClass = tmp.asSubclass(SemanticsType.class);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return typeClass;
    }

    public void registerSemanticSurface(String type, Class<? extends SemanticsType> semanticSurfaceClass) throws ExtensionException {
        if (type == null) {
            throw new ExtensionException("The semantic surface type must not be null.");
        }
        if (semanticSurfaceClass == null) {
            throw new ExtensionException("The semantic surface class must not be null.");
        }
        if (this.semanticSurfaces.containsKey(type)) {
            throw new ExtensionException("The semantic surface type '" + type + "' is already registered.");
        }
        if (this.semanticSurfaces.containsValue(semanticSurfaceClass)) {
            throw new ExtensionException("The semantic surface class '" + semanticSurfaceClass.getTypeName() + "' is already registered.");
        }
        this.semanticSurfaces.put(type, semanticSurfaceClass);
    }

    public void unregisterSemanticSurface(String type) {
        this.semanticSurfaces.remove(type);
    }

    public Type getExtensionPropertyClass(String propertyName, ExtensibleType target) {
        for (Map.Entry<Class<? extends ExtensibleType>, Map<String, Type>> entry : this.properties.entrySet()) {
            if (!entry.getKey().isInstance(target)) continue;
            return entry.getValue().get(propertyName);
        }
        return null;
    }

    public boolean hasExtensionProperty(String propertyName, ExtensibleType target) {
        return this.getExtensionPropertyClass(propertyName, target) != null;
    }

    public boolean hasExtensionProperty(String propertyName, Class<? extends ExtensibleType> targetClass) {
        return this.properties.getOrDefault(targetClass, Collections.emptyMap()).containsKey(propertyName);
    }

    public void registerExtensionProperty(String name, Type attributeType, Class<? extends ExtensibleType> targetClass) throws ExtensionException {
        if (name == null) {
            throw new ExtensionException("The extension property name must not be null.");
        }
        if (attributeType == null) {
            throw new ExtensionException("The extension property type must not be null.");
        }
        if (targetClass == null) {
            throw new ExtensionException("The extension property target class must not be null.");
        }
        for (Map.Entry<Class<? extends ExtensibleType>, Map<String, Type>> entry : this.properties.entrySet()) {
            if (!entry.getKey().isAssignableFrom(targetClass) && !targetClass.isAssignableFrom(entry.getKey()) || !entry.getValue().containsKey(name)) continue;
            throw new ExtensionException("The extension property '" + name + "' is already registered with " + entry.getKey().getTypeName());
        }
        Map property = this.properties.computeIfAbsent(targetClass, v -> new ConcurrentHashMap());
        property.put(name, attributeType);
    }

    public void unregisterExtensionProperty(String name, Class<? extends ExtensibleType> targetClass) {
        if (targetClass != null) {
            for (Map.Entry<Class<? extends ExtensibleType>, Map<String, Type>> entry : this.properties.entrySet()) {
                if (!entry.getKey().isAssignableFrom(targetClass) && !targetClass.isAssignableFrom(entry.getKey())) continue;
                entry.getValue().remove(name);
            }
        }
    }
}

