/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.appearance;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.citygml4j.cityjson.appearance.AbstractTextureObject;

public class TextureAdapter<T extends AbstractTextureObject>
extends TypeAdapter<Map<String, T>> {
    private final Gson gson;
    private final Class<T> typeOfT;

    public TextureAdapter(Gson gson, Class<T> typeOfT) {
        this.gson = gson;
        this.typeOfT = typeOfT;
    }

    public void write(JsonWriter out, Map<String, T> value) throws IOException {
        if (value != null) {
            out.beginObject();
            for (Map.Entry<String, T> entry : value.entrySet()) {
                out.name(entry.getKey());
                Streams.write((JsonElement)this.gson.toJsonTree(entry.getValue(), this.typeOfT), (JsonWriter)out);
            }
            out.endObject();
        } else {
            out.nullValue();
        }
    }

    public Map<String, T> read(JsonReader in) throws IOException {
        HashMap<String, AbstractTextureObject> textures = null;
        if (in.peek() != JsonToken.NULL) {
            textures = new HashMap<String, AbstractTextureObject>();
            in.beginObject();
            while (in.hasNext()) {
                String theme = in.nextName();
                AbstractTextureObject material = (AbstractTextureObject)this.gson.fromJson(in, this.typeOfT);
                material.theme = theme;
                textures.put(theme, material);
            }
            in.endObject();
        } else {
            in.nextNull();
        }
        return textures;
    }
}

