/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.feature;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateAdapter
extends TypeAdapter<LocalDate> {
    public void write(JsonWriter out, LocalDate value) throws IOException {
        if (value != null) {
            out.value(value.format(DateTimeFormatter.ISO_LOCAL_DATE));
        } else {
            out.nullValue();
        }
    }

    public LocalDate read(JsonReader in) throws IOException {
        if (in.peek() != JsonToken.NULL) {
            try {
                return LocalDate.parse(in.nextString());
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return null;
    }
}

