/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.appearance.SolidCollectionMaterialObject;
import org.citygml4j.cityjson.appearance.SolidCollectionTextureObject;
import org.citygml4j.cityjson.geometry.AbstractSolidType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;
import org.citygml4j.cityjson.geometry.GeometryWithAppearance;
import org.citygml4j.cityjson.geometry.SolidCollectionSemanticsObject;

public abstract class AbstractSolidCollectionType
extends AbstractSolidType
implements GeometryWithAppearance<SolidCollectionMaterialObject, SolidCollectionTextureObject> {
    private final GeometryTypeName type;
    private List<List<List<List<List<Integer>>>>> boundaries = new ArrayList<List<List<List<List<Integer>>>>>();
    private SolidCollectionSemanticsObject semantics;
    private Map<String, SolidCollectionMaterialObject> material;
    private Map<String, SolidCollectionTextureObject> texture;

    public AbstractSolidCollectionType(GeometryTypeName type) {
        this.type = type;
    }

    @Override
    public GeometryTypeName getType() {
        return this.type;
    }

    public void addSolid(List<List<List<List<Integer>>>> solid) {
        if (solid != null && solid.size() > 0) {
            this.boundaries.add(solid);
        }
    }

    public List<List<List<List<List<Integer>>>>> getSolids() {
        return this.boundaries;
    }

    public void setSolids(List<List<List<List<List<Integer>>>>> solids) {
        if (solids != null) {
            this.boundaries = solids;
        }
    }

    public void unsetSolids() {
        this.boundaries.clear();
    }

    @Override
    public boolean isSetSemantics() {
        return this.semantics != null;
    }

    @Override
    public SolidCollectionSemanticsObject getSemantics() {
        return this.semantics;
    }

    public void setSemantics(SolidCollectionSemanticsObject semantics) {
        this.semantics = semantics;
    }

    @Override
    public void unsetSemantics() {
        this.semantics = null;
    }

    @Override
    public boolean isSetMaterial() {
        return this.material != null;
    }

    public void addMaterial(SolidCollectionMaterialObject materialObject) {
        if (this.material == null) {
            this.material = new HashMap<String, SolidCollectionMaterialObject>();
        }
        this.material.put(materialObject.getTheme(), materialObject);
    }

    @Override
    public Collection<SolidCollectionMaterialObject> getMaterial() {
        return this.material.values();
    }

    @Override
    public SolidCollectionMaterialObject getMaterial(String theme) {
        return this.material != null ? this.material.get(theme) : null;
    }

    public void setMaterial(List<SolidCollectionMaterialObject> material) {
        if (material == null) {
            this.material = null;
        } else {
            for (SolidCollectionMaterialObject object : material) {
                this.material.put(object.getTheme(), object);
            }
        }
    }

    @Override
    public void removeMaterial(SolidCollectionMaterialObject materialObject) {
        if (this.material != null) {
            this.material.remove(materialObject.getTheme());
        }
    }

    @Override
    public void removeMaterial(String theme) {
        if (this.material != null) {
            this.material.remove(theme);
        }
    }

    @Override
    public void unsetMaterial() {
        this.material = null;
    }

    @Override
    public boolean isSetTexture() {
        return this.texture != null;
    }

    public void addTexture(SolidCollectionTextureObject textureObject) {
        if (this.texture == null) {
            this.texture = new HashMap<String, SolidCollectionTextureObject>();
        }
        this.texture.put(textureObject.getTheme(), textureObject);
    }

    @Override
    public Collection<SolidCollectionTextureObject> getTexture() {
        return this.texture.values();
    }

    @Override
    public SolidCollectionTextureObject getTexture(String theme) {
        return this.texture != null ? this.texture.get(theme) : null;
    }

    public void setTexture(List<SolidCollectionTextureObject> texture) {
        if (texture == null) {
            this.texture = null;
        } else {
            for (SolidCollectionTextureObject object : texture) {
                this.texture.put(object.getTheme(), object);
            }
        }
    }

    @Override
    public void removeTexture(SolidCollectionTextureObject textureObject) {
        if (this.texture != null) {
            this.texture.remove(textureObject.getTheme());
        }
    }

    @Override
    public void removeTexture(String theme) {
        if (this.texture != null) {
            this.texture.remove(theme);
        }
    }

    @Override
    public void unsetTexture() {
        this.texture = null;
    }

    @Override
    public void unsetAppearance() {
        this.material = null;
        this.texture = null;
    }

    @Override
    public void updateIndexes(Map<Integer, Integer> indexMap) {
        for (List<List<List<List<Integer>>>> solid : this.boundaries) {
            for (List<List<List<Integer>>> shell : solid) {
                for (List<List<Integer>> surface : shell) {
                    for (List<Integer> ring : surface) {
                        for (int index = 0; index < ring.size(); ++index) {
                            Integer update = indexMap.get(ring.get(index));
                            if (update == null) continue;
                            ring.set(index, update);
                        }
                    }
                }
            }
        }
    }
}

