/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.appearance.SurfaceCollectionMaterialObject;
import org.citygml4j.cityjson.appearance.SurfaceCollectionTextureObject;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;
import org.citygml4j.cityjson.geometry.GeometryWithAppearance;
import org.citygml4j.cityjson.geometry.GeometryWithSemantics;
import org.citygml4j.cityjson.geometry.SurfaceCollectionSemanticsObject;

public abstract class AbstractSurfaceCollectionType
extends AbstractGeometryObjectType
implements GeometryWithSemantics,
GeometryWithAppearance<SurfaceCollectionMaterialObject, SurfaceCollectionTextureObject> {
    private final GeometryTypeName type;
    private List<List<List<Integer>>> boundaries = new ArrayList<List<List<Integer>>>();
    private SurfaceCollectionSemanticsObject semantics;
    private Map<String, SurfaceCollectionMaterialObject> material;
    private Map<String, SurfaceCollectionTextureObject> texture;

    protected AbstractSurfaceCollectionType(GeometryTypeName type) {
        this.type = type;
    }

    @Override
    public GeometryTypeName getType() {
        return this.type;
    }

    public void addSurface(List<List<Integer>> surface) {
        if (surface != null && surface.size() > 0) {
            this.boundaries.add(surface);
        }
    }

    public List<List<List<Integer>>> getSurfaces() {
        return this.boundaries;
    }

    public void setSurfaces(List<List<List<Integer>>> surfaces) {
        if (surfaces != null) {
            this.boundaries = surfaces;
        }
    }

    public void unsetSurfaces() {
        this.boundaries.clear();
    }

    @Override
    public boolean isSetSemantics() {
        return this.semantics != null;
    }

    @Override
    public SurfaceCollectionSemanticsObject getSemantics() {
        return this.semantics;
    }

    public void setSemantics(SurfaceCollectionSemanticsObject semantics) {
        this.semantics = semantics;
    }

    @Override
    public void unsetSemantics() {
        this.semantics = null;
    }

    @Override
    public boolean isSetMaterial() {
        return this.material != null;
    }

    public void addMaterial(SurfaceCollectionMaterialObject materialObject) {
        if (this.material == null) {
            this.material = new HashMap<String, SurfaceCollectionMaterialObject>();
        }
        this.material.put(materialObject.getTheme(), materialObject);
    }

    @Override
    public Collection<SurfaceCollectionMaterialObject> getMaterial() {
        return this.material.values();
    }

    @Override
    public SurfaceCollectionMaterialObject getMaterial(String theme) {
        return this.material != null ? this.material.get(theme) : null;
    }

    public void setMaterial(List<SurfaceCollectionMaterialObject> material) {
        if (material == null) {
            this.material = null;
        } else {
            for (SurfaceCollectionMaterialObject object : material) {
                this.material.put(object.getTheme(), object);
            }
        }
    }

    @Override
    public void removeMaterial(SurfaceCollectionMaterialObject materialObject) {
        if (this.material != null) {
            this.material.remove(materialObject.getTheme());
        }
    }

    @Override
    public void removeMaterial(String theme) {
        if (this.material != null) {
            this.material.remove(theme);
        }
    }

    @Override
    public void unsetMaterial() {
        this.material = null;
    }

    @Override
    public boolean isSetTexture() {
        return this.texture != null;
    }

    public void addTexture(SurfaceCollectionTextureObject textureObject) {
        if (this.texture == null) {
            this.texture = new HashMap<String, SurfaceCollectionTextureObject>();
        }
        this.texture.put(textureObject.getTheme(), textureObject);
    }

    @Override
    public Collection<SurfaceCollectionTextureObject> getTexture() {
        return this.texture.values();
    }

    @Override
    public SurfaceCollectionTextureObject getTexture(String theme) {
        return this.texture != null ? this.texture.get(theme) : null;
    }

    public void setTexture(List<SurfaceCollectionTextureObject> texture) {
        if (texture == null) {
            this.texture = null;
        } else {
            for (SurfaceCollectionTextureObject object : texture) {
                this.texture.put(object.getTheme(), object);
            }
        }
    }

    @Override
    public void removeTexture(SurfaceCollectionTextureObject textureObject) {
        if (this.texture != null) {
            this.texture.remove(textureObject.getTheme());
        }
    }

    @Override
    public void removeTexture(String theme) {
        if (this.texture != null) {
            this.texture.remove(theme);
        }
    }

    @Override
    public void unsetTexture() {
        this.texture = null;
    }

    @Override
    public void unsetAppearance() {
        this.material = null;
        this.texture = null;
    }

    @Override
    public void updateIndexes(Map<Integer, Integer> indexMap) {
        for (List<List<Integer>> surface : this.boundaries) {
            for (List<Integer> ring : surface) {
                for (int index = 0; index < ring.size(); ++index) {
                    Integer update = indexMap.get(ring.get(index));
                    if (update == null) continue;
                    ring.set(index, update);
                }
            }
        }
    }
}

