/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;

public class MultiPointType
extends AbstractGeometryObjectType {
    private final GeometryTypeName type = GeometryTypeName.MULTI_POINT;
    private List<Integer> boundaries = new ArrayList<Integer>();

    @Override
    public GeometryTypeName getType() {
        return this.type;
    }

    public void addPoint(int point) {
        this.boundaries.add(point);
    }

    public void addPoints(List<Integer> points) {
        if (points != null && points.size() > 0) {
            this.boundaries.addAll(points);
        }
    }

    public List<Integer> getPoints() {
        return this.boundaries;
    }

    public void setPoints(List<Integer> points) {
        if (points != null) {
            this.boundaries = points;
        }
    }

    public void unsetPoints() {
        this.boundaries.clear();
    }

    @Override
    public void updateIndexes(Map<Integer, Integer> indexMap) {
        for (int index = 0; index < this.boundaries.size(); ++index) {
            Integer update = indexMap.get(this.boundaries.get(index));
            if (update == null) continue;
            this.boundaries.set(index, update);
        }
    }
}

