/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.cityjson.util.PropertyHelper;

public class SemanticsTypeAdapter
extends TypeAdapter<SemanticsType> {
    private final Gson gson;
    private final TypeAdapterFactory factory;
    private final CityJSONRegistry registry = CityJSONRegistry.getInstance();
    private final Map<String, List<String>> predefinedAttributes = new HashMap<String, List<String>>();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public SemanticsTypeAdapter(Gson gson, TypeAdapterFactory factory) {
        this.gson = gson;
        this.factory = factory;
    }

    public void write(JsonWriter out, SemanticsType value) throws IOException {
        if (value != null) {
            Class<? extends SemanticsType> typeOf;
            TypeAdapter delegate;
            JsonElement element;
            if (value.type == null) {
                value.type = this.registry.getSemanticSurfaceType(value);
            }
            if ((element = (delegate = this.gson.getDelegateAdapter(this.factory, TypeToken.get(typeOf = this.registry.getSemanticSurfaceClass(value.type)))).toJsonTree((Object)value)) != null && element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                if (value.isSetAttributes()) {
                    JsonObject properties = this.gson.toJsonTree(value.getAttributes()).getAsJsonObject();
                    for (Map.Entry entry : properties.entrySet()) {
                        object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
            }
            Streams.write((JsonElement)element, (JsonWriter)out);
        } else {
            out.nullValue();
        }
    }

    public SemanticsType read(JsonReader in) throws IOException {
        Class<? extends SemanticsType> typeOf;
        JsonObject object;
        JsonPrimitive type;
        if (in.peek() != JsonToken.NULL && (type = (object = Streams.parse((JsonReader)in).getAsJsonObject()).getAsJsonPrimitive("type")) != null && (typeOf = this.registry.getSemanticSurfaceClass(type.getAsString())) != null) {
            SemanticsType semantics = (SemanticsType)this.gson.getDelegateAdapter(this.factory, TypeToken.get(typeOf)).fromJsonTree((JsonElement)object);
            List predefined = this.predefinedAttributes.computeIfAbsent(semantics.getClass().getTypeName(), v -> this.propertyHelper.getDeclaredProperties(semantics.getClass()));
            for (Map.Entry entry : object.entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                if (predefined.contains(key) || (value = this.propertyHelper.deserialize((JsonElement)entry.getValue())) == null) continue;
                semantics.addAttribute(key, value);
            }
            return semantics;
        }
        return null;
    }
}

