/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.appearance.SolidMaterialObject;
import org.citygml4j.cityjson.appearance.SolidTextureObject;
import org.citygml4j.cityjson.geometry.AbstractSolidType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;
import org.citygml4j.cityjson.geometry.GeometryWithAppearance;
import org.citygml4j.cityjson.geometry.SolidSemanticsObject;

public class SolidType
extends AbstractSolidType
implements GeometryWithAppearance<SolidMaterialObject, SolidTextureObject> {
    private final GeometryTypeName type = GeometryTypeName.SOLID;
    private List<List<List<List<Integer>>>> boundaries = new ArrayList<List<List<List<Integer>>>>();
    private SolidSemanticsObject semantics;
    private Map<String, SolidMaterialObject> material;
    private Map<String, SolidTextureObject> texture;

    @Override
    public GeometryTypeName getType() {
        return this.type;
    }

    public void addShell(List<List<List<Integer>>> shell) {
        if (shell != null && shell.size() > 0) {
            this.boundaries.add(shell);
        }
    }

    public List<List<List<List<Integer>>>> getShells() {
        return this.boundaries;
    }

    public void setShells(List<List<List<List<Integer>>>> shells) {
        if (shells != null) {
            this.boundaries = shells;
        }
    }

    public void unsetShells() {
        this.boundaries.clear();
    }

    @Override
    public boolean isSetSemantics() {
        return this.semantics != null;
    }

    @Override
    public SolidSemanticsObject getSemantics() {
        return this.semantics;
    }

    public void setSemantics(SolidSemanticsObject semantics) {
        this.semantics = semantics;
    }

    @Override
    public void unsetSemantics() {
        this.semantics = null;
    }

    @Override
    public boolean isSetMaterial() {
        return this.material != null;
    }

    public void addMaterial(SolidMaterialObject materialObject) {
        if (this.material == null) {
            this.material = new HashMap<String, SolidMaterialObject>();
        }
        this.material.put(materialObject.getTheme(), materialObject);
    }

    @Override
    public Collection<SolidMaterialObject> getMaterial() {
        return this.material.values();
    }

    @Override
    public SolidMaterialObject getMaterial(String theme) {
        return this.material != null ? this.material.get(theme) : null;
    }

    public void setMaterial(List<SolidMaterialObject> material) {
        if (material == null) {
            this.material = null;
        } else {
            for (SolidMaterialObject object : material) {
                this.material.put(object.getTheme(), object);
            }
        }
    }

    @Override
    public void removeMaterial(SolidMaterialObject materialObject) {
        if (this.material != null) {
            this.material.remove(materialObject.getTheme());
        }
    }

    @Override
    public void removeMaterial(String theme) {
        if (this.material != null) {
            this.material.remove(theme);
        }
    }

    @Override
    public void unsetMaterial() {
        this.material = null;
    }

    @Override
    public boolean isSetTexture() {
        return this.texture != null;
    }

    public void addTexture(SolidTextureObject textureObject) {
        if (this.texture == null) {
            this.texture = new HashMap<String, SolidTextureObject>();
        }
        this.texture.put(textureObject.getTheme(), textureObject);
    }

    @Override
    public Collection<SolidTextureObject> getTexture() {
        return this.texture.values();
    }

    @Override
    public SolidTextureObject getTexture(String theme) {
        return this.texture != null ? this.texture.get(theme) : null;
    }

    public void setTexture(List<SolidTextureObject> texture) {
        if (texture == null) {
            this.texture = null;
        } else {
            for (SolidTextureObject object : texture) {
                this.texture.put(object.getTheme(), object);
            }
        }
    }

    @Override
    public void removeTexture(SolidTextureObject textureObject) {
        if (this.texture != null) {
            this.texture.remove(textureObject.getTheme());
        }
    }

    @Override
    public void removeTexture(String theme) {
        if (this.texture != null) {
            this.texture.remove(theme);
        }
    }

    @Override
    public void unsetTexture() {
        this.texture = null;
    }

    @Override
    public void unsetAppearance() {
        this.material = null;
        this.texture = null;
    }

    @Override
    public void updateIndexes(Map<Integer, Integer> indexMap) {
        for (List<List<List<Integer>>> shell : this.boundaries) {
            for (List<List<Integer>> surface : shell) {
                for (List<Integer> ring : surface) {
                    for (int index = 0; index < ring.size(); ++index) {
                        Integer update = indexMap.get(ring.get(index));
                        if (update == null) continue;
                        ring.set(index, update);
                    }
                }
            }
        }
    }
}

