/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.citygml4j.cityjson.geometry.VerticesList;

public class VerticesListAdapter
extends TypeAdapter<VerticesList> {
    private boolean asInteger;

    public VerticesListAdapter(boolean asInteger) {
        this.asInteger = asInteger;
    }

    public VerticesListAdapter() {
        this(false);
    }

    public void write(JsonWriter out, VerticesList value) throws IOException {
        if (value != null) {
            out.beginArray();
            for (List<Double> vertex : value.getVertices()) {
                if (vertex != null) {
                    out.beginArray();
                    for (double coordinate : vertex) {
                        if (this.asInteger) {
                            out.value((long)((int)coordinate));
                            continue;
                        }
                        out.value(coordinate);
                    }
                    out.endArray();
                    continue;
                }
                out.nullValue();
            }
            out.endArray();
        } else {
            out.nullValue();
        }
    }

    public VerticesList read(JsonReader in) throws IOException {
        VerticesList vertices = null;
        if (in.peek() != JsonToken.NULL) {
            vertices = new VerticesList();
            in.beginArray();
            while (in.hasNext()) {
                if (in.peek() == JsonToken.NULL) {
                    vertices.addVertex(null);
                    in.nextNull();
                    continue;
                }
                ArrayList<Double> vertex = new ArrayList<Double>(3);
                in.beginArray();
                if (in.peek() == JsonToken.NUMBER) {
                    vertex.add(in.nextDouble());
                    vertex.add(in.nextDouble());
                    vertex.add(in.nextDouble());
                }
                vertices.addVertex(vertex);
                in.endArray();
            }
            in.endArray();
        }
        return vertices;
    }
}

