/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.json.io.reader;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.Reader;
import org.citygml4j.builder.cityjson.json.io.reader.CityJSONReadException;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.util.CityGMLMetadata;
import org.citygml4j.builder.cityjson.util.TextureFileHandler;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.CityJSONTypeAdapterFactory;
import org.citygml4j.cityjson.extension.ExtensionException;
import org.citygml4j.cityjson.feature.CityObjectTypeFilter;
import org.citygml4j.xml.io.reader.CityGMLInputFilter;

public abstract class AbstractCityJSONReader
implements AutoCloseable {
    private final Reader reader;
    private final boolean processUnknownExtensions;
    private CityObjectTypeFilter typeFilter;
    private CityGMLInputFilter nameFilter;
    private TextureFileHandler textureFileHandler;

    public AbstractCityJSONReader(Reader reader, boolean processUnknownExtensions) {
        this.reader = reader;
        this.processUnknownExtensions = processUnknownExtensions;
        CityJSONRegistry registry = CityJSONRegistry.getInstance();
        if (!registry.hasExtensionProperty("CityGMLMetadata", CityJSON.class)) {
            try {
                registry.registerExtensionProperty("CityGMLMetadata", CityGMLMetadata.class, CityJSON.class);
            }
            catch (ExtensionException extensionException) {
                // empty catch block
            }
        }
    }

    public TextureFileHandler getTextureFileHandler() {
        return this.textureFileHandler;
    }

    public void setTextureFileHandler(TextureFileHandler textureFileHandler) {
        this.textureFileHandler = textureFileHandler;
    }

    void setObjectTypeFilter(CityObjectTypeFilter typeFilter) {
        this.typeFilter = typeFilter;
    }

    void setCityGMLNameFilter(CityGMLInputFilter nameFilter) {
        this.nameFilter = nameFilter;
    }

    CityJSON readCityJSON() throws CityJSONReadException {
        try {
            return (CityJSON)new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CityJSONTypeAdapterFactory().withTypeFilter(this.typeFilter).processUnknownExtensions(this.processUnknownExtensions)).create().fromJson(this.reader, CityJSON.class);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    CityJSONUnmarshaller getCityJSONUnmarshaller() {
        CityJSONUnmarshaller unmarshaller = new CityJSONUnmarshaller();
        if (this.nameFilter != null) {
            unmarshaller.setCityGMLNameFilter(this.nameFilter);
        }
        if (this.textureFileHandler != null) {
            unmarshaller.setTextureFileHandler(this.textureFileHandler);
        }
        return unmarshaller;
    }

    @Override
    public void close() throws CityJSONReadException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }
}

