/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.json.io.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.citygml4j.builder.cityjson.json.io.reader.AbstractCityJSONReader;
import org.citygml4j.builder.cityjson.json.io.reader.CityJSONChunkReader;
import org.citygml4j.builder.cityjson.json.io.reader.CityJSONReadException;
import org.citygml4j.builder.cityjson.json.io.reader.CityJSONReader;
import org.citygml4j.cityjson.feature.CityObjectTypeFilter;
import org.citygml4j.xml.io.reader.CityGMLInputFilter;

public class CityJSONInputFactory {
    boolean processUnknownExtensions;

    public CityJSONReader createCityJSONReader(File file) throws CityJSONReadException {
        try {
            return new CityJSONReader((Reader)new BufferedReader(new FileReader(file)), this);
        }
        catch (FileNotFoundException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    public CityJSONReader createCityJSONReader(File file, String encoding) throws CityJSONReadException {
        try {
            return new CityJSONReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)), this);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    public CityJSONReader createCityJSONReader(InputStream inputStream) throws CityJSONReadException {
        return new CityJSONReader((Reader)new InputStreamReader(inputStream), this);
    }

    public CityJSONReader createCityJSONReader(InputStream inputStream, String encoding) throws CityJSONReadException {
        try {
            return new CityJSONReader((Reader)new InputStreamReader(inputStream, encoding), this);
        }
        catch (UnsupportedEncodingException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    public CityJSONChunkReader createCityJSONChunkReader(File file) throws CityJSONReadException {
        try {
            return new CityJSONChunkReader((Reader)new BufferedReader(new FileReader(file)), this);
        }
        catch (FileNotFoundException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    public CityJSONChunkReader createCityJSONChunkReader(File file, String encoding) throws CityJSONReadException {
        try {
            return new CityJSONChunkReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)), this);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    public CityJSONChunkReader createCityJSONChunkReader(InputStream inputStream) throws CityJSONReadException {
        return new CityJSONChunkReader((Reader)new InputStreamReader(inputStream), this);
    }

    public CityJSONChunkReader createCityJSONChunkReader(InputStream inputStream, String encoding) throws CityJSONReadException {
        try {
            return new CityJSONChunkReader((Reader)new InputStreamReader(inputStream, encoding), this);
        }
        catch (UnsupportedEncodingException e) {
            throw new CityJSONReadException("Caused by: ", e);
        }
    }

    public <T extends AbstractCityJSONReader> T createFilteredCityJSONReader(T reader, CityObjectTypeFilter filter) throws CityJSONReadException {
        reader.setObjectTypeFilter(filter);
        return reader;
    }

    public <T extends AbstractCityJSONReader> T createFilteredCityJSONReader(T reader, CityGMLInputFilter filter) throws CityJSONReadException {
        reader.setCityGMLNameFilter(filter);
        return reader;
    }

    public boolean isProcessUnknownExtensions() {
        return this.processUnknownExtensions;
    }

    public void setProcessUnknownExtensions(boolean processUnknownExtensions) {
        this.processUnknownExtensions = processUnknownExtensions;
    }
}

