/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.json.io.writer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionContext;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionModule;
import org.citygml4j.builder.cityjson.extension.ExtensionModuleVersion;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONOutputFactory;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONWriteException;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.TextureVerticesBuilder;
import org.citygml4j.builder.cityjson.marshal.util.VerticesBuilder;
import org.citygml4j.builder.cityjson.marshal.util.VerticesTransformer;
import org.citygml4j.builder.cityjson.util.TextureFileHandler;
import org.citygml4j.cityjson.CityJSONTypeAdapterFactory;
import org.citygml4j.cityjson.extension.ExtensionType;
import org.citygml4j.cityjson.metadata.MetadataType;
import org.citygml4j.model.citygml.ade.binding.ADEContext;

public abstract class AbstractCityJSONWriter
implements AutoCloseable {
    protected final JsonWriter writer;
    protected final CityJSONMarshaller marshaller;
    protected final Gson gson;
    private final CityJSONTypeAdapterFactory typeAdapterFactory;
    protected MetadataType metadata;
    protected Map<String, ExtensionType> extensions;
    protected boolean calcBoundingBox = true;
    protected boolean calcPresentLods = true;

    public AbstractCityJSONWriter(JsonWriter writer, CityJSONOutputFactory factory) {
        this.writer = writer;
        this.marshaller = new CityJSONMarshaller();
        this.marshaller.setRemoveDuplicateChildGeometries(factory.removeDuplicateChildGeometries);
        this.marshaller.setGenerateCityGMLMetadata(factory.generateCityGMLMetadata);
        this.marshaller.setUseMaterialDefaults(factory.useMaterialDefaults);
        this.marshaller.setFallbackTheme(factory.fallbackTheme);
        this.typeAdapterFactory = new CityJSONTypeAdapterFactory();
        this.gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)this.typeAdapterFactory).create();
    }

    public VerticesBuilder getVerticesBuilder() {
        return this.marshaller.getVerticesBuilder();
    }

    public void setVerticesBuilder(VerticesBuilder verticesBuilder) {
        this.marshaller.setVerticesBuilder(verticesBuilder);
    }

    public VerticesTransformer getVerticesTransformer() {
        return this.marshaller.getVerticesTransformer();
    }

    public void setVerticesTransformer(VerticesTransformer verticesTransformer) {
        this.marshaller.setVerticesTransformer(verticesTransformer);
        this.typeAdapterFactory.serializeVerticesAsInteger(true);
    }

    public TextureVerticesBuilder getTextureVerticesBuilder() {
        return this.marshaller.getTextureVerticesBuilder();
    }

    public void setTextureVerticesBuilder(TextureVerticesBuilder textureVerticesBuilder) {
        this.marshaller.setTextureVerticesBuilder(textureVerticesBuilder);
    }

    public VerticesBuilder getTemplatesVerticesBuilder() {
        return this.marshaller.getTemplatesVerticesBuilder();
    }

    public void setTemplatesVerticesBuilder(VerticesBuilder templatesVerticesBuilder) {
        this.marshaller.setTemplatesVerticesBuilder(templatesVerticesBuilder);
    }

    public TextureFileHandler getTextureFileHandler() {
        return this.marshaller.getTextureFileHandler();
    }

    public void setTextureFileHandler(TextureFileHandler textureFileHandler) {
        this.marshaller.setTextureFileHandler(textureFileHandler);
    }

    public MetadataType getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    protected MetadataType getOrCreateMetadata() {
        if (this.metadata == null) {
            this.metadata = new MetadataType();
        }
        return this.metadata;
    }

    public void setExtension(String name, ExtensionType extension) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, ExtensionType>();
        }
        this.extensions.put(name, extension);
    }

    public void setExtensions(List<ADEContext> adeContexts) {
        for (ADEContext adeContext : adeContexts) {
            if (!(adeContext instanceof CityJSONExtensionContext)) continue;
            for (CityJSONExtensionModule module : ((CityJSONExtensionContext)((Object)adeContext)).getCityJSONExtension().getExtensionModules()) {
                if (module == null) continue;
                String identifier = module.getIdentifier();
                String schemaURI = module.getSchemaURI();
                ExtensionModuleVersion version = module.getVersion();
                if (identifier == null || schemaURI == null || version == null) continue;
                ExtensionType extension = new ExtensionType(schemaURI, version.getMajor(), version.getMinor());
                this.setExtension(identifier, extension);
            }
        }
    }

    public void setIndent(String indent) {
        this.writer.setIndent(indent);
    }

    public boolean isHtmlSafe() {
        return this.writer.isHtmlSafe();
    }

    public void setHtmlSafe(boolean htmlSafe) {
        this.writer.setHtmlSafe(htmlSafe);
    }

    public CityJSONMarshaller getCityJSONMarshaller() {
        return this.marshaller;
    }

    public boolean isCalcBoundingBox() {
        return this.calcBoundingBox;
    }

    public void setCalcBoundingBox(boolean calcBoundingBox) {
        this.calcBoundingBox = calcBoundingBox;
    }

    public boolean isCalcPresentLods() {
        return this.calcPresentLods;
    }

    public void setCalcPresentLods(boolean calcPresentLods) {
        this.calcPresentLods = calcPresentLods;
    }

    public void flush() throws CityJSONWriteException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    @Override
    public void close() throws CityJSONWriteException {
        try {
            this.marshaller.reset();
            if (this.extensions != null) {
                this.extensions.clear();
            }
            this.writer.close();
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }
}

