/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.json.io.writer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.builder.cityjson.json.io.writer.AbstractCityJSONWriter;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONOutputFactory;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONWriteException;
import org.citygml4j.builder.cityjson.marshal.citygml.core.CoreMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.generics.GenericsMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.AppearanceResolver;
import org.citygml4j.builder.cityjson.marshal.util.VerticesTransformer;
import org.citygml4j.builder.cityjson.util.CityGMLMetadata;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.TransformType;
import org.citygml4j.cityjson.geometry.VerticesList;
import org.citygml4j.cityjson.metadata.MetadataType;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.core.AbstractCityObject;

public class CityJSONChunkWriter
extends AbstractCityJSONWriter {
    private final String TYPE = "type";
    private final String CITYJSON = "CityJSON";
    private final String VERSION = "version";
    private final String CITY_OBJECTS = "CityObjects";
    private final String VERTICES = "vertices";
    private final String TRANSFORM = "transform";
    private final String APPEARANCE = "appearance";
    private final String MATERIALS = "materials";
    private final String TEXTURES = "textures";
    private final String VERTICES_TEXTURE = "vertices-texture";
    private final String GEOMETRY_TEMPLATES = "geometry-templates";
    private final String TEMPLATES = "templates";
    private final String VERTICES_TEMPLATES = "vertices-templates";
    private final String METADATA = "metadata";
    private final String EXTENSIONS = "extensions";
    private DocumentState documentState = DocumentState.INITIAL;
    private Map<String, Object> extensionProperties = new HashMap<String, Object>();
    private Map<String, Integer> lods = new HashMap<String, Integer>();

    public CityJSONChunkWriter(JsonWriter writer, CityJSONOutputFactory factory) {
        super(writer, factory);
    }

    public void registerGlobalAppearance(Appearance appearance) {
        switch (this.documentState) {
            case START_DOCUMENT: 
            case END_DOCUMENT: {
                throw new IllegalStateException("Global appearances cannot be registered after document has been initialized.");
            }
        }
        this.marshaller.getAppearanceResolver().registerGlobalAppearance(appearance);
    }

    public void addRootExtensionProperty(String name, Object value) {
        this.extensionProperties.put(name, value);
    }

    public void writeStartDocument() throws CityJSONWriteException {
        switch (this.documentState) {
            case START_DOCUMENT: {
                throw new IllegalStateException("CityJSON document is already initialized.");
            }
            case END_DOCUMENT: {
                throw new IllegalStateException("CityJSON document is already complete.");
            }
        }
        try {
            this.writer.beginObject();
            this.writer.name("type");
            this.writer.value("CityJSON");
            this.writer.name("version");
            this.writer.value("1.0");
            this.writer.name("CityObjects");
            this.writer.beginObject();
            this.documentState = DocumentState.START_DOCUMENT;
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public void writeCityObject(AbstractCityObject cityObject) throws CityJSONWriteException {
        switch (this.documentState) {
            case END_DOCUMENT: {
                throw new IllegalStateException("CityJSON document is already complete.");
            }
            case INITIAL: {
                this.writeStartDocument();
                break;
            }
        }
        CityJSON cityJSON = new CityJSON();
        AbstractCityObjectType dest = this.marshaller.marshal(cityObject, cityJSON);
        for (AbstractCityObjectType child : cityJSON.getCityObjects()) {
            this.write(child);
        }
        if (cityJSON.isSetExtensionProperties()) {
            this.extensionProperties.putAll(cityJSON.getExtensionProperties());
        }
        if (dest != null) {
            this.write(dest);
        }
    }

    public void writeCityObject(AbstractCityObjectType cityObject) throws CityJSONWriteException {
        switch (this.documentState) {
            case END_DOCUMENT: {
                throw new IllegalStateException("CityJSON document is already complete.");
            }
            case INITIAL: {
                this.writeStartDocument();
                break;
            }
        }
        this.write(cityObject);
    }

    private void write(AbstractCityObjectType cityObject) throws CityJSONWriteException {
        try {
            for (AbstractGeometryType geometry : cityObject.getGeometry()) {
                String lod;
                if (!(geometry instanceof AbstractGeometryObjectType) || (lod = String.valueOf(((AbstractGeometryObjectType)geometry).getLod())) == null) continue;
                this.lods.merge(lod, 1, Integer::sum);
            }
            this.writer.name(cityObject.getGmlId());
            this.gson.toJson((Object)cityObject, AbstractCityObjectType.class, this.writer);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public void writeEndDocument() throws CityJSONWriteException {
        switch (this.documentState) {
            case END_DOCUMENT: {
                throw new IllegalStateException("CityJSON document is already complete.");
            }
            case INITIAL: {
                this.writeStartDocument();
            }
        }
        try {
            GenericsMarshaller genericsMarshaller;
            CoreMarshaller coreMarshaller;
            List<List<Double>> vertices;
            this.writer.endObject();
            if (!this.extensionProperties.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.extensionProperties.entrySet()) {
                    this.writer.name(entry.getKey());
                    this.gson.toJson(entry.getValue(), Object.class, this.writer);
                }
            }
            if ((vertices = this.marshaller.getVerticesBuilder().build()) == null) {
                vertices = Collections.emptyList();
            }
            TransformType transform = null;
            VerticesTransformer verticesTransformer = this.marshaller.getVerticesTransformer();
            if (!vertices.isEmpty() && verticesTransformer != null && (transform = verticesTransformer.applyTransformation(vertices)) != null) {
                this.writer.name("transform");
                this.gson.toJson((Object)transform, TransformType.class, this.writer);
            }
            this.writer.name("vertices");
            this.gson.toJson((Object)new VerticesList(vertices), VerticesList.class, this.writer);
            AppearanceResolver appearanceResolver = this.marshaller.getAppearanceResolver();
            if (appearanceResolver.hasTextures() || appearanceResolver.hasMaterials()) {
                List<List<Double>> textureVertices;
                this.writer.name("appearance");
                this.writer.beginObject();
                if (appearanceResolver.hasMaterials()) {
                    this.writer.name("materials");
                    this.gson.toJson(appearanceResolver.getMaterials(), List.class, this.writer);
                }
                if (appearanceResolver.hasTextures() && (textureVertices = this.marshaller.getTextureVerticesBuilder().build()).size() > 0) {
                    this.writer.name("textures");
                    this.gson.toJson(appearanceResolver.getTextures(), List.class, this.writer);
                    this.writer.name("vertices-texture");
                    this.gson.toJson(textureVertices, List.class, this.writer);
                }
                this.writer.endObject();
            }
            if ((coreMarshaller = this.marshaller.getCityGMLMarshaller().getCoreMarshaller()).hasGeometryTemplates()) {
                this.writer.name("geometry-templates");
                this.writer.beginObject();
                List<AbstractGeometryObjectType> geometryTemplates = coreMarshaller.getGeometryTemplates();
                this.writer.name("templates");
                this.gson.toJson(geometryTemplates, List.class, this.writer);
                geometryTemplates.forEach(g -> {
                    String lod = String.valueOf(g.getLod());
                    if (lod != null) {
                        this.lods.merge(lod, 1, Integer::sum);
                    }
                });
                List<List<Double>> templatesVertices = this.marshaller.getTemplatesVerticesBuilder().build();
                if (templatesVertices.size() > 0) {
                    this.writer.name("vertices-templates");
                    this.gson.toJson(templatesVertices, List.class, this.writer);
                }
                this.writer.endObject();
            }
            if (!(!this.calcBoundingBox || this.metadata != null && this.metadata.isSetGeographicalExtent() || vertices.isEmpty())) {
                CityJSON cityJSON = new CityJSON();
                cityJSON.setVertices(vertices);
                List bbox = cityJSON.calcBoundingBox();
                if (transform != null) {
                    for (int i = 0; i < bbox.size(); ++i) {
                        bbox.set(i, (Double)bbox.get(i) * (Double)transform.getScale().get(i % 3) + (Double)transform.getTranslate().get(i % 3));
                    }
                }
                this.getOrCreateMetadata().setGeographicalExtent(bbox);
            }
            if (!(!this.calcPresentLods || this.metadata != null && this.metadata.isSetPresentLoDs() || this.lods.isEmpty())) {
                this.getOrCreateMetadata().setPresentLoDs(this.lods);
            }
            if (this.metadata != null) {
                this.writer.name("metadata");
                this.gson.toJson((Object)this.metadata, MetadataType.class, this.writer);
            }
            if ((genericsMarshaller = this.marshaller.getCityGMLMarshaller().getGenericsMarshaller()).hasGenericAttributeTypes()) {
                CityGMLMetadata cityGMLMetadata = new CityGMLMetadata();
                cityGMLMetadata.setGenericAttributeTypes(genericsMarshaller.getGenericAttributeTypes());
                this.writer.name("CityGMLMetadata");
                this.gson.toJson((Object)cityGMLMetadata, CityGMLMetadata.class, this.writer);
            }
            if (this.extensions != null) {
                this.writer.name("extensions");
                this.gson.toJson((Object)this.extensions, Map.class, this.writer);
            }
            this.writer.endObject();
            this.documentState = DocumentState.END_DOCUMENT;
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    @Override
    public void close() throws CityJSONWriteException {
        switch (this.documentState) {
            case INITIAL: {
                this.writeStartDocument();
            }
            case START_DOCUMENT: {
                this.writeEndDocument();
            }
        }
        this.extensionProperties.clear();
        this.lods.clear();
        super.close();
    }

    private static enum DocumentState {
        INITIAL,
        START_DOCUMENT,
        END_DOCUMENT;

    }
}

