/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.json.io.writer;

import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONChunkWriter;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONWriteException;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONWriter;

public class CityJSONOutputFactory {
    boolean removeDuplicateChildGeometries;
    boolean generateCityGMLMetadata;
    boolean useMaterialDefaults = true;
    String fallbackTheme = "unnamed";

    public CityJSONWriter createCityJSONWriter(File file) throws CityJSONWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new CityJSONWriter(new JsonWriter((Writer)new BufferedWriter(new FileWriter(file))), this);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(File file, String encoding) throws CityJSONWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new CityJSONWriter(new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding))), this);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(OutputStream outputStream) {
        return new CityJSONWriter(new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream))), this);
    }

    public CityJSONWriter createCityJSONWriter(OutputStream outputStream, String encoding) throws CityJSONWriteException {
        try {
            return new CityJSONWriter(new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, encoding))), this);
        }
        catch (UnsupportedEncodingException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(Writer writer) {
        return new CityJSONWriter(new JsonWriter(writer), this);
    }

    public CityJSONChunkWriter createCityJSONChunkWriter(File file) throws CityJSONWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new CityJSONChunkWriter(new JsonWriter((Writer)new BufferedWriter(new FileWriter(file))), this);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public CityJSONChunkWriter createCityJSONChunkWriter(File file, String encoding) throws CityJSONWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new CityJSONChunkWriter(new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding))), this);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public CityJSONChunkWriter createCityJSONChunkWriter(OutputStream outputStream) {
        return new CityJSONChunkWriter(new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream))), this);
    }

    public CityJSONChunkWriter createCityJSONChunkWriter(OutputStream outputStream, String encoding) throws CityJSONWriteException {
        try {
            return new CityJSONChunkWriter(new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, encoding))), this);
        }
        catch (UnsupportedEncodingException e) {
            throw new CityJSONWriteException("Caused by: ", e);
        }
    }

    public CityJSONChunkWriter createCityJSONChunkWriter(Writer writer) {
        return new CityJSONChunkWriter(new JsonWriter(writer), this);
    }

    public boolean isRemoveDuplicateChildGeometries() {
        return this.removeDuplicateChildGeometries;
    }

    public void setRemoveDuplicateChildGeometries(boolean removeDuplicateChildGeometries) {
        this.removeDuplicateChildGeometries = removeDuplicateChildGeometries;
    }

    public boolean isGenerateCityGMLMetadata() {
        return this.generateCityGMLMetadata;
    }

    public void setGenerateCityGMLMetadata(boolean generateCityGMLMetadata) {
        this.generateCityGMLMetadata = generateCityGMLMetadata;
    }

    public boolean isUseMaterialDefaults() {
        return this.useMaterialDefaults;
    }

    public void setUseMaterialDefaults(boolean useMaterialDefaults) {
        this.useMaterialDefaults = useMaterialDefaults;
    }

    public String getFallbackTheme() {
        return this.fallbackTheme;
    }

    public void setFallbackTheme(String fallbackTheme) {
        this.fallbackTheme = fallbackTheme;
    }

    private void createParentDirectories(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

