/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.json.io.writer;

import com.google.gson.stream.JsonWriter;
import org.citygml4j.builder.cityjson.json.io.writer.AbstractCityJSONWriter;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONOutputFactory;
import org.citygml4j.builder.cityjson.json.io.writer.CityJSONWriteException;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.model.citygml.core.CityModel;

public class CityJSONWriter
extends AbstractCityJSONWriter {
    private DocumentState documentState = DocumentState.INITIAL;

    public CityJSONWriter(JsonWriter writer, CityJSONOutputFactory factory) {
        super(writer, factory);
    }

    public void write(CityModel cityModel) throws CityJSONWriteException {
        if (this.documentState == DocumentState.END_DOCUMENT) {
            throw new IllegalStateException("CityJSON document is already complete.");
        }
        CityJSON cityJSON = this.marshaller.marshal(cityModel);
        if (cityJSON != null) {
            if (!(!this.calcBoundingBox || this.metadata != null && this.metadata.isSetGeographicalExtent() || cityJSON.getVertices().isEmpty())) {
                this.getOrCreateMetadata().setGeographicalExtent(cityJSON.calcBoundingBox());
            }
            if (this.calcPresentLods && (this.metadata == null || !this.metadata.isSetPresentLoDs()) && cityJSON.hasCityObjects()) {
                this.getOrCreateMetadata().setPresentLoDs(cityJSON.calcPresentLoDs());
            }
            if (this.metadata != null) {
                cityJSON.setMetadata(this.metadata);
            }
            if (this.extensions != null) {
                cityJSON.setExtensions(this.extensions);
            }
            this.gson.toJson((Object)cityJSON, CityJSON.class, this.writer);
        }
        this.documentState = DocumentState.END_DOCUMENT;
    }

    @Override
    public void close() throws CityJSONWriteException {
        if (this.documentState == DocumentState.INITIAL) {
            this.gson.toJson((Object)new CityJSON(), CityJSON.class, this.writer);
        }
        super.close();
    }

    private static enum DocumentState {
        INITIAL,
        END_DOCUMENT;

    }
}

