/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal;

import java.util.List;
import java.util.Objects;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.ade.ADEMarshaller;
import org.citygml4j.builder.cityjson.marshal.gml.GMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.AppearanceResolver;
import org.citygml4j.builder.cityjson.marshal.util.DefaultTextureVerticesBuilder;
import org.citygml4j.builder.cityjson.marshal.util.DefaultVerticesBuilder;
import org.citygml4j.builder.cityjson.marshal.util.GeometryXlinkResolver;
import org.citygml4j.builder.cityjson.marshal.util.LocalPropertiesCleaner;
import org.citygml4j.builder.cityjson.marshal.util.TextureVerticesBuilder;
import org.citygml4j.builder.cityjson.marshal.util.VerticesBuilder;
import org.citygml4j.builder.cityjson.marshal.util.VerticesTransformer;
import org.citygml4j.builder.cityjson.util.CityGMLMetadata;
import org.citygml4j.builder.cityjson.util.DefaultTextureFileHandler;
import org.citygml4j.builder.cityjson.util.TextureFileHandler;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.appearance.AppearanceType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.GeometryTemplatesType;
import org.citygml4j.cityjson.geometry.TransformType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;

public class CityJSONMarshaller {
    public static final String GEOMETRY_XLINK = "org.citygml4j.geometry.xlink";
    public static final String GEOMETRY_SURFACE_DATA = "org.citygml4j.geometry.surfaceData";
    public static final String GEOMETRY_DUMMY = "org.citygml4j.geometry.dummy";
    private final CityGMLMarshaller citygml;
    private final GMLMarshaller gml;
    private final ADEMarshaller ade;
    private final GeometryXlinkResolver xlinkResolver;
    private final AppearanceResolver appearanceResolver;
    private VerticesBuilder verticesBuilder = new DefaultVerticesBuilder();
    private VerticesTransformer verticesTransformer;
    private TextureVerticesBuilder textureVerticesBuilder = new DefaultTextureVerticesBuilder();
    private TextureFileHandler textureFileHandler = new DefaultTextureFileHandler();
    private VerticesBuilder templatesVerticesBuilder = new DefaultVerticesBuilder();
    private boolean removeDuplicateChildGeometries;
    private boolean generateCityGMLMetadata;
    private boolean useMaterialDefaults = true;
    private String fallbackTheme = "unnamed";

    public CityJSONMarshaller() {
        this.citygml = new CityGMLMarshaller(this);
        this.gml = new GMLMarshaller(this, this::getVerticesBuilder);
        this.ade = new ADEMarshaller(this);
        this.xlinkResolver = new GeometryXlinkResolver();
        this.appearanceResolver = new AppearanceResolver(this);
    }

    public void reset() {
        this.verticesBuilder.reset();
        this.textureVerticesBuilder.reset();
        this.templatesVerticesBuilder.reset();
    }

    public CityJSON marshal(CityModel src) {
        this.xlinkResolver.resolve(src);
        this.appearanceResolver.resolve(src);
        CityJSON dest = new CityJSON();
        this.citygml.marshal(src, dest);
        if (dest.hasCityObjects()) {
            TransformType transform;
            List<List<Double>> vertices = this.verticesBuilder.build();
            dest.setVertices(vertices);
            if (this.verticesTransformer != null && (transform = this.verticesTransformer.applyTransformation(vertices)) != null) {
                dest.setTransform(transform);
                dest.removeDuplicateVertices();
            }
            if (this.appearanceResolver.hasTextures() || this.appearanceResolver.hasMaterials()) {
                List<List<Double>> textureVertices;
                AppearanceType appearance = new AppearanceType();
                dest.setAppearance(appearance);
                if (this.appearanceResolver.hasMaterials()) {
                    appearance.setMaterials(this.appearanceResolver.getMaterials());
                }
                if (this.appearanceResolver.hasTextures() && (textureVertices = this.textureVerticesBuilder.build()).size() > 0) {
                    appearance.setTextures(this.appearanceResolver.getTextures());
                    appearance.setTextureVertices(textureVertices);
                }
            }
            if (this.citygml.getCoreMarshaller().hasGeometryTemplates()) {
                GeometryTemplatesType geometryTemplates = new GeometryTemplatesType();
                dest.setGeometryTemplates(geometryTemplates);
                geometryTemplates.setTemplates(this.citygml.getCoreMarshaller().getGeometryTemplates());
                geometryTemplates.setTemplatesVertices(this.templatesVerticesBuilder.build());
            }
            if (this.citygml.getGenericsMarshaller().hasGenericAttributeTypes()) {
                CityGMLMetadata metadata = new CityGMLMetadata();
                metadata.setGenericAttributeTypes(this.citygml.getGenericsMarshaller().getGenericAttributeTypes());
                dest.addExtensionProperty("CityGMLMetadata", (Object)metadata);
            }
        }
        src.accept(new LocalPropertiesCleaner());
        return dest;
    }

    public AbstractCityObjectType marshal(AbstractCityObject src, CityJSON cityJSON) {
        this.xlinkResolver.resolve(src);
        this.appearanceResolver.resolve(src);
        AbstractCityObjectType dest = this.citygml.marshal(src, cityJSON);
        src.accept(new LocalPropertiesCleaner());
        return dest;
    }

    public CityGMLMarshaller getCityGMLMarshaller() {
        return this.citygml;
    }

    public GMLMarshaller getGMLMarshaller() {
        return this.gml;
    }

    public ADEMarshaller getADEMarshaller() {
        return this.ade;
    }

    public GeometryXlinkResolver getGeometryXlinkResolver() {
        return this.xlinkResolver;
    }

    public AppearanceResolver getAppearanceResolver() {
        return this.appearanceResolver;
    }

    public VerticesBuilder getVerticesBuilder() {
        return this.verticesBuilder;
    }

    public void setVerticesBuilder(VerticesBuilder verticesBuilder) {
        this.verticesBuilder = Objects.requireNonNull(verticesBuilder, "vertices builder may not be null.");
    }

    public VerticesTransformer getVerticesTransformer() {
        return this.verticesTransformer;
    }

    public void setVerticesTransformer(VerticesTransformer verticesTransformer) {
        this.verticesTransformer = Objects.requireNonNull(verticesTransformer, "vertices transformer may not be null.");
    }

    public TextureVerticesBuilder getTextureVerticesBuilder() {
        return this.textureVerticesBuilder;
    }

    public void setTextureVerticesBuilder(TextureVerticesBuilder textureVerticesBuilder) {
        this.textureVerticesBuilder = Objects.requireNonNull(textureVerticesBuilder, "texture vertices builder may not be null.");
    }

    public VerticesBuilder getTemplatesVerticesBuilder() {
        return this.templatesVerticesBuilder;
    }

    public void setTemplatesVerticesBuilder(VerticesBuilder templatesVerticesBuilder) {
        this.templatesVerticesBuilder = Objects.requireNonNull(templatesVerticesBuilder, "templates vertices builder may not be null.");
    }

    public TextureFileHandler getTextureFileHandler() {
        return this.textureFileHandler;
    }

    public void setTextureFileHandler(TextureFileHandler textureFileHandler) {
        this.textureFileHandler = Objects.requireNonNull(textureFileHandler, "texture file handler builder may not be null.");
    }

    public boolean isRemoveDuplicateChildGeometries() {
        return this.removeDuplicateChildGeometries;
    }

    public void setRemoveDuplicateChildGeometries(boolean removeDuplicateChildGeometries) {
        this.removeDuplicateChildGeometries = removeDuplicateChildGeometries;
    }

    public boolean isGenerateCityGMLMetadata() {
        return this.generateCityGMLMetadata;
    }

    public void setGenerateCityGMLMetadata(boolean generateCityGMLMetadata) {
        this.generateCityGMLMetadata = generateCityGMLMetadata;
    }

    public boolean isUseMaterialDefaults() {
        return this.useMaterialDefaults;
    }

    public void setUseMaterialDefaults(boolean useMaterialDefaults) {
        this.useMaterialDefaults = useMaterialDefaults;
    }

    public String getFallbackTheme() {
        return this.fallbackTheme;
    }

    public void setFallbackTheme(String fallbackTheme) {
        this.fallbackTheme = fallbackTheme;
    }
}

