/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.ade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.CityGMLContext;
import org.citygml4j.builder.cityjson.extension.ADEPropertyContext;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionContext;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionMarshaller;
import org.citygml4j.builder.cityjson.extension.ExtensionAttribute;
import org.citygml4j.builder.cityjson.extension.ExtensionProperty;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.ade.ADEMarshallerHelper;
import org.citygml4j.builder.cityjson.marshal.util.DuplicateGeometryRemover;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.extension.Extension;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;

public class ADEMarshaller {
    private final CityJSONMarshaller json;
    private Map<String, CityJSONExtensionMarshaller> marshallers;

    public ADEMarshaller(CityJSONMarshaller json) {
        this.json = json;
        CityGMLContext context = CityGMLContext.getInstance();
        if (context.hasCityJSONExtensionContexts()) {
            this.marshallers = new HashMap<String, CityJSONExtensionMarshaller>();
            ADEMarshallerHelper helper = new ADEMarshallerHelper(json);
            for (ADEContext adeContext : context.getADEContexts()) {
                CityJSONExtensionMarshaller marshaller;
                if (!(adeContext instanceof CityJSONExtensionContext) || (marshaller = ((CityJSONExtensionContext)((Object)adeContext)).getCityJSONExtension().createExtensionMarshaller()) == null) continue;
                marshaller.setADEMarshallerHelper(helper);
                for (String packageName : adeContext.getModelPackageNames()) {
                    this.marshallers.put(packageName, marshaller);
                }
            }
        }
    }

    public void marshal(List<ADEComponent> src, ExtensibleType parent, CityJSON cityJSON) {
        for (ADEComponent ade : src) {
            CityJSONExtensionMarshaller marshaller;
            if (!(ade instanceof ADEModelObject) || this.marshallers == null || (marshaller = this.marshallers.get(ade.getClass().getPackage().getName())) == null) continue;
            Extension extension = marshaller.marshalGenericApplicationProperty((ADEModelObject)ade, new ADEPropertyContext(parent, cityJSON));
            if (extension instanceof AbstractCityObjectType) {
                AbstractCityObjectType cityObject = (AbstractCityObjectType)extension;
                if (parent instanceof AbstractCityObjectType) {
                    if (this.json.isRemoveDuplicateChildGeometries()) {
                        DuplicateGeometryRemover remover = new DuplicateGeometryRemover((AbstractCityObjectType)parent);
                        remover.removeDuplicateGeometries(cityObject);
                        if (!cityObject.isSetGeometry()) continue;
                    }
                    cityJSON.addCityObject(cityObject);
                }
                parent.addChild(cityObject);
                continue;
            }
            if (extension instanceof ExtensionAttribute && parent instanceof AbstractCityObjectType) {
                ExtensionAttribute attribute = (ExtensionAttribute)extension;
                ((AbstractCityObjectType)parent).getAttributes().addExtensionAttribute(attribute.getName(), attribute.getValue());
                continue;
            }
            if (!(extension instanceof ExtensionProperty)) continue;
            ExtensionProperty property = (ExtensionProperty)extension;
            if (parent instanceof AbstractCityObjectType) {
                ((AbstractCityObjectType)parent).addExtensionProperty(property.getName(), property.getValue());
                continue;
            }
            if (!(parent instanceof CityJSON)) continue;
            ((CityJSON)parent).addExtensionProperty(property.getName(), property.getValue());
        }
    }

    public AbstractCityObjectType marshalCityObject(ADEModelObject src, CityJSON cityJSON) {
        CityJSONExtensionMarshaller marshaller;
        if (this.marshallers != null && (marshaller = this.marshallers.get(src.getClass().getPackage().getName())) != null) {
            return marshaller.marshalCityObject(src, cityJSON);
        }
        return null;
    }

    public SemanticsType marshalSemanticSurface(ADEModelObject src) {
        CityJSONExtensionMarshaller marshaller;
        if (this.marshallers != null && (marshaller = this.marshallers.get(src.getClass().getPackage().getName())) != null) {
            return marshaller.marshalSemanticSurface(src);
        }
        return null;
    }
}

