/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.appearance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.SurfaceDataInfo;
import org.citygml4j.cityjson.appearance.MaterialType;
import org.citygml4j.cityjson.appearance.TextureType;
import org.citygml4j.cityjson.appearance.TextureTypeName;
import org.citygml4j.cityjson.appearance.TextureTypeType;
import org.citygml4j.cityjson.appearance.WrapModeType;
import org.citygml4j.model.citygml.appearance.ParameterizedTexture;
import org.citygml4j.model.citygml.appearance.X3DMaterial;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.primitives.AbstractRing;
import org.citygml4j.model.gml.geometry.primitives.AbstractRingProperty;
import org.citygml4j.model.gml.geometry.primitives.LinearRing;
import org.citygml4j.model.gml.geometry.primitives.Polygon;
import org.citygml4j.util.child.ChildInfo;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;

public class AppearanceMarshaller {
    private final CityJSONMarshaller json;
    private final ChildInfo childInfo;

    public AppearanceMarshaller(CityGMLMarshaller citygml) {
        this.json = citygml.getCityJSONMarshaller();
        this.childInfo = new ChildInfo();
    }

    public void marshalParameterizedTexture(ParameterizedTexture src, TextureType dest) {
        if (src.isSetImageURI()) {
            String fileName = this.json.getTextureFileHandler().getImageURI(src.getImageURI());
            if (fileName == null) {
                return;
            }
            dest.setType(TextureTypeName.fromFileName((String)fileName));
            dest.setImage(fileName);
        }
        if (src.isSetWrapMode()) {
            dest.setWrapMode(WrapModeType.fromValue((String)src.getWrapMode().getValue()));
        }
        if (src.isSetTextureType()) {
            dest.setTextureType(TextureTypeType.fromValue((String)src.getTextureType().getValue()));
        }
        if (src.isSetBorderColor()) {
            dest.setBorderColor(src.getBorderColor().toList());
        }
    }

    public TextureType marshalParameterizedTexture(ParameterizedTexture src) {
        TextureType dest = new TextureType();
        this.marshalParameterizedTexture(src, dest);
        return dest;
    }

    public void marshalX3DMaterial(X3DMaterial src, MaterialType dest) {
        if (src.isSetName()) {
            for (Code name : src.getName()) {
                if (!name.isSetValue()) continue;
                dest.setName(name.getValue());
                break;
            }
        }
        if (!dest.isSetName()) {
            dest.setName(src.isSetId() ? src.getId() : DefaultGMLIdManager.getInstance().generateUUID());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetAmbientIntensity()) {
            dest.setAmbientIntensity(src.getAmbientIntensity());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetDiffuseColor()) {
            dest.setDiffuseColor(src.getDiffuseColor().toList());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetEmissiveColor()) {
            dest.setEmissiveColor(src.getEmissiveColor().toList());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetSpecularColor()) {
            dest.setSpecularColor(src.getSpecularColor().toList());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetShininess()) {
            dest.setShininess(src.getShininess());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetTransparency()) {
            dest.setTransparency(src.getTransparency());
        }
        if (this.json.isUseMaterialDefaults() || src.isSetIsSmooth()) {
            dest.setIsSmooth(src.getIsSmooth());
        }
    }

    public MaterialType marshalX3DMaterial(X3DMaterial src) {
        MaterialType dest = new MaterialType();
        this.marshalX3DMaterial(src, dest);
        return dest;
    }

    public Map<String, Integer> getMaterials(AbstractGeometry geometry, boolean reverse) {
        HashMap<String, Integer> materials = null;
        do {
            if (this.json.getAppearanceResolver().hasGlobalAppearance() && !geometry.hasLocalProperty("org.citygml4j.geometry.surfaceData")) {
                this.json.getAppearanceResolver().resolveGlobalAppearance(geometry);
            }
            if (!geometry.hasLocalProperty("org.citygml4j.geometry.surfaceData")) continue;
            if (materials == null) {
                materials = new HashMap<String, Integer>();
            }
            List surfaceDatas = (List)geometry.getLocalProperty("org.citygml4j.geometry.surfaceData");
            for (SurfaceDataInfo surfaceData : surfaceDatas) {
                if (!surfaceData.isMaterial() || surfaceData.isFront() == reverse) continue;
                String theme = surfaceData.getTheme();
                if (materials.containsKey(surfaceData.getTheme())) continue;
                materials.put(theme, surfaceData.getSequenceNumber());
            }
        } while ((geometry = this.childInfo.getParentGeometry(geometry)) != null);
        return materials != null && !materials.isEmpty() ? materials : null;
    }

    public Map<String, List<List<Integer>>> getTextures(Polygon polygon, boolean reverse) {
        LinearRing linearRing;
        Map<String, List<Integer>> tmp;
        AbstractRing exterior;
        HashMap textures = null;
        if (polygon.isSetExterior() && (exterior = polygon.getExterior().getRing()) instanceof LinearRing && (tmp = this.collectTextures(linearRing = (LinearRing)exterior, reverse)) != null && !tmp.isEmpty()) {
            textures = new HashMap();
            for (Map.Entry<String, List<Integer>> entry : tmp.entrySet()) {
                ArrayList<List<Integer>> indexes = new ArrayList<List<Integer>>();
                indexes.add(entry.getValue());
                textures.put(entry.getKey(), indexes);
            }
            if (polygon.isSetInterior()) {
                for (AbstractRingProperty property : polygon.getInterior()) {
                    AbstractRing interior = property.getRing();
                    if (!(interior instanceof LinearRing) || (tmp = this.collectTextures(linearRing = (LinearRing)interior, reverse)) == null || tmp.isEmpty()) continue;
                    for (Map.Entry<String, List<Integer>> entry : tmp.entrySet()) {
                        List indexes = (List)textures.get(entry.getKey());
                        if (indexes == null || indexes.size() <= 0) continue;
                        indexes.add(entry.getValue());
                    }
                }
            }
        }
        return textures;
    }

    public Map<String, List<List<Integer>>> getTextures(LinearRing linearRing, boolean reverse) {
        HashMap<String, List<List<Integer>>> textures = null;
        Map<String, List<Integer>> tmp = this.collectTextures(linearRing, reverse);
        if (tmp != null && !tmp.isEmpty()) {
            textures = new HashMap<String, List<List<Integer>>>();
            for (Map.Entry<String, List<Integer>> entry : tmp.entrySet()) {
                textures.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
        return textures;
    }

    private Map<String, List<Integer>> collectTextures(LinearRing linearRing, boolean reverse) {
        HashMap<String, List<Integer>> textures = null;
        if (this.json.getAppearanceResolver().hasGlobalAppearance() && !linearRing.hasLocalProperty("org.citygml4j.geometry.surfaceData")) {
            this.json.getAppearanceResolver().resolveGlobalAppearance(linearRing);
        }
        if (linearRing.hasLocalProperty("org.citygml4j.geometry.surfaceData")) {
            textures = new HashMap<String, List<Integer>>();
            List surfaceDatas = (List)linearRing.getLocalProperty("org.citygml4j.geometry.surfaceData");
            for (SurfaceDataInfo surfaceData : surfaceDatas) {
                List<Double> textureCoordinates;
                if (surfaceData.isMaterial() || surfaceData.isFront() == reverse) continue;
                String theme = surfaceData.getTheme();
                if (textures.containsKey(surfaceData.getTheme()) || (textureCoordinates = surfaceData.getTextureCoordinates()) == null || textureCoordinates.size() <= 7) continue;
                List<Integer> indexes = this.json.getTextureVerticesBuilder().addTextureVertices(textureCoordinates.subList(0, textureCoordinates.size() - 2));
                indexes.add(0, surfaceData.getSequenceNumber());
                textures.put(theme, indexes);
            }
        }
        return textures;
    }
}

