/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.bridge;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.DuplicateGeometryRemover;
import org.citygml4j.builder.cityjson.marshal.util.SemanticSurfaceCollector;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.feature.AbstractBridgeType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.BridgeAttributes;
import org.citygml4j.cityjson.feature.BridgeConstructionElementType;
import org.citygml4j.cityjson.feature.BridgeInstallationType;
import org.citygml4j.cityjson.feature.BridgePartType;
import org.citygml4j.cityjson.feature.BridgeType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.bridge.AbstractBoundarySurface;
import org.citygml4j.model.citygml.bridge.AbstractBridge;
import org.citygml4j.model.citygml.bridge.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.bridge.Bridge;
import org.citygml4j.model.citygml.bridge.BridgeConstructionElement;
import org.citygml4j.model.citygml.bridge.BridgeConstructionElementProperty;
import org.citygml4j.model.citygml.bridge.BridgeInstallation;
import org.citygml4j.model.citygml.bridge.BridgeInstallationProperty;
import org.citygml4j.model.citygml.bridge.BridgePart;
import org.citygml4j.model.citygml.bridge.BridgePartProperty;
import org.citygml4j.model.citygml.bridge.ClosureSurface;
import org.citygml4j.model.citygml.bridge.Door;
import org.citygml4j.model.citygml.bridge.GroundSurface;
import org.citygml4j.model.citygml.bridge.OuterCeilingSurface;
import org.citygml4j.model.citygml.bridge.OuterFloorSurface;
import org.citygml4j.model.citygml.bridge.RoofSurface;
import org.citygml4j.model.citygml.bridge.WallSurface;
import org.citygml4j.model.citygml.bridge.Window;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.AddressProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class BridgeMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> typeMapper;

    public BridgeMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(Bridge.class, this::marshalBridge).with(BridgePart.class, this::marshalBridgePart).with(BridgeConstructionElement.class, this::marshalBridgeConstructionElement).with(BridgeInstallation.class, this::marshalBridgeInstallation);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public SemanticsType marshalSemantics(AbstractCityObject cityObject) {
        SemanticsType semantics = null;
        if (cityObject instanceof RoofSurface) {
            semantics = new SemanticsType("RoofSurface");
        } else if (cityObject instanceof GroundSurface) {
            semantics = new SemanticsType("GroundSurface");
        } else if (cityObject instanceof WallSurface) {
            semantics = new SemanticsType("WallSurface");
        } else if (cityObject instanceof ClosureSurface) {
            semantics = new SemanticsType("ClosureSurface");
        } else if (cityObject instanceof OuterCeilingSurface) {
            semantics = new SemanticsType("OuterCeilingSurface");
        } else if (cityObject instanceof OuterFloorSurface) {
            semantics = new SemanticsType("OuterFloorSurface");
        } else if (cityObject instanceof Window) {
            semantics = new SemanticsType("Window");
        } else if (cityObject instanceof Door) {
            semantics = new SemanticsType("Door");
        }
        if (semantics != null) {
            this.citygml.getGenericsMarshaller().marshalGenericAttributes(cityObject, semantics);
        }
        return semantics;
    }

    public void marshalAbstractBridge(AbstractBridge src, AbstractBridgeType dest, CityJSON cityJSON) {
        AbstractCityObjectType cityObject;
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractSite(src, (AbstractCityObjectType)dest, cityJSON);
        BridgeAttributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetYearOfConstruction()) {
            attributes.setYearOfConstruction(Integer.valueOf(src.getYearOfConstruction().getYear()));
        }
        if (src.isSetYearOfDemolition()) {
            attributes.setYearOfDemolition(Integer.valueOf(src.getYearOfDemolition().getYear()));
        }
        if (src.isSetIsMovable()) {
            attributes.setIsMovable(src.getIsMovable().booleanValue());
        }
        if (src.isSetGenericApplicationPropertyOfAbstractBridge()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfAbstractBridge(), (ExtensibleType)dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod1MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            geometry.setLod((Number)1);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSurface())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSurface())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod1Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Solid())) != null) {
            geometry.setLod((Number)1);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Solid())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Solid())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        DuplicateGeometryRemover remover = null;
        if (this.json.isRemoveDuplicateChildGeometries()) {
            remover = new DuplicateGeometryRemover((AbstractCityObjectType)dest);
        }
        if (src.isSetOuterBridgeConstructionElement()) {
            for (BridgeConstructionElementProperty bridgeConstructionElementProperty : src.getOuterBridgeConstructionElement()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(bridgeConstructionElementProperty, cityJSON);
                if (!(cityObject instanceof BridgeConstructionElementType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (src.isSetOuterBridgeInstallation()) {
            for (BridgeInstallationProperty bridgeInstallationProperty : src.getOuterBridgeInstallation()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(bridgeInstallationProperty, cityJSON);
                if (!(cityObject instanceof BridgeInstallationType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (dest instanceof BridgeType && src.isSetConsistsOfBridgePart()) {
            for (BridgePartProperty bridgePartProperty : src.getConsistsOfBridgePart()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(bridgePartProperty, cityJSON);
                if (!(cityObject instanceof BridgePartType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (src.isSetAddress()) {
            for (AddressProperty addressProperty : src.getAddress()) {
                if (!addressProperty.isSetAddress()) continue;
                dest.setAddress(this.citygml.getCoreMarshaller().marshalAddress(addressProperty.getAddress()));
                break;
            }
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public void marshalBridge(Bridge src, BridgeType dest, CityJSON cityJSON) {
        this.marshalAbstractBridge(src, (AbstractBridgeType)dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfBridge()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBridge(), (ExtensibleType)dest, cityJSON);
        }
    }

    public BridgeType marshalBridge(Bridge src, CityJSON cityJSON) {
        BridgeType dest = new BridgeType();
        this.marshalBridge(src, dest, cityJSON);
        return dest;
    }

    public void marshalBridgePart(BridgePart src, BridgePartType dest, CityJSON cityJSON) {
        this.marshalAbstractBridge(src, (AbstractBridgeType)dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfBridgePart()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBridgePart(), (ExtensibleType)dest, cityJSON);
        }
    }

    public BridgePartType marshalBridgePart(BridgePart src, CityJSON cityJSON) {
        BridgePartType dest = new BridgePartType();
        this.marshalBridgePart(src, dest, cityJSON);
        return dest;
    }

    public void marshalBridgeConstructionElement(BridgeConstructionElement src, BridgeConstructionElementType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, (AbstractCityObjectType)dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfBridgeConstructionElement()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBridgeConstructionElement(), (ExtensibleType)dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public BridgeConstructionElementType marshalBridgeConstructionElement(BridgeConstructionElement src, CityJSON cityJSON) {
        BridgeConstructionElementType dest = new BridgeConstructionElementType();
        this.marshalBridgeConstructionElement(src, dest, cityJSON);
        return dest;
    }

    public void marshalBridgeInstallation(BridgeInstallation src, BridgeInstallationType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, (AbstractCityObjectType)dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfBridgeInstallation()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBridgeInstallation(), (ExtensibleType)dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public BridgeInstallationType marshalBridgeInstallation(BridgeInstallation src, CityJSON cityJSON) {
        BridgeInstallationType dest = new BridgeInstallationType();
        this.marshalBridgeInstallation(src, dest, cityJSON);
        return dest;
    }

    private SemanticSurfaceCollector preprocessGeometry(AbstractBridge src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2MultiSurface, src::setLod2MultiSurface, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3MultiSurface, src::setLod3MultiSurface, lod);
        }
        return collector;
    }

    private void postprocessGeometry(AbstractBridge src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2MultiSurface, src::unsetLod2MultiSurface);
                continue;
            }
            collector.clean(src::getLod3MultiSurface, src::unsetLod3MultiSurface);
        }
    }

    private SemanticSurfaceCollector preprocessGeometry(BridgeInstallation src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2Geometry, src::setLod2Geometry, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3Geometry, src::setLod3Geometry, lod);
        }
        return collector;
    }

    private void postprocessGeometry(BridgeInstallation src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2Geometry, src::unsetLod2Geometry);
                continue;
            }
            collector.clean(src::getLod3Geometry, src::unsetLod3Geometry);
        }
    }

    private SemanticSurfaceCollector preprocessGeometry(BridgeConstructionElement src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2Geometry, src::setLod2Geometry, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3Geometry, src::setLod3Geometry, lod);
        }
        return collector;
    }

    private void postprocessGeometry(BridgeConstructionElement src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2Geometry, src::unsetLod2Geometry);
                continue;
            }
            collector.clean(src::getLod3Geometry, src::unsetLod3Geometry);
        }
    }

    private SemanticSurfaceCollector collectBoundarySurfaces(AbstractCityObject cityObject, List<BoundarySurfaceProperty> boundaryProperties) {
        SemanticSurfaceCollector collector = new SemanticSurfaceCollector(cityObject);
        for (BoundarySurfaceProperty boundaryProperty : boundaryProperties) {
            if (!boundaryProperty.isSetBoundarySurface()) continue;
            AbstractBoundarySurface boundarySurface = boundaryProperty.getBoundarySurface();
            collector.collectSurfaces(boundarySurface, 2, 3);
            collector.collectSurfaces(boundarySurface.getOpening(), 2, 3);
        }
        return collector;
    }
}

