/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.relief;

import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.TINReliefType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.model.citygml.relief.ReliefComponentProperty;
import org.citygml4j.model.citygml.relief.ReliefFeature;
import org.citygml4j.model.citygml.relief.TINRelief;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class ReliefMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> typeMapper;

    public ReliefMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(ReliefFeature.class, this::marshalReliefFeature).with(TINRelief.class, this::marshalTINRelief);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public AbstractCityObjectType marshalReliefFeature(ReliefFeature src, CityJSON cityJSON) {
        if (src.isSetReliefComponent()) {
            for (ReliefComponentProperty property : src.getReliefComponent()) {
                if (!property.isSetReliefComponent() || !(property.getReliefComponent() instanceof TINRelief)) continue;
                cityJSON.addCityObject((AbstractCityObjectType)this.marshalTINRelief((TINRelief)property.getReliefComponent(), cityJSON));
            }
        }
        return null;
    }

    public void marshalTINRelief(TINRelief src, TINReliefType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, (AbstractCityObjectType)dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfTinRelief()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfTinRelief(), (ExtensibleType)dest, cityJSON);
        }
        if (src.isSetTin() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getTin())) != null) {
            geometry.setLod((Number)src.getLod());
            dest.addGeometry((AbstractGeometryType)geometry);
        }
    }

    public TINReliefType marshalTINRelief(TINRelief src, CityJSON cityJSON) {
        TINReliefType dest = new TINReliefType();
        this.marshalTINRelief(src, dest, cityJSON);
        return dest;
    }
}

