/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.vegetation;

import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.PlantCoverAttributes;
import org.citygml4j.cityjson.feature.PlantCoverType;
import org.citygml4j.cityjson.feature.SolitaryVegetationObjectAttributes;
import org.citygml4j.cityjson.feature.SolitaryVegetationObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.model.citygml.vegetation.AbstractVegetationObject;
import org.citygml4j.model.citygml.vegetation.PlantCover;
import org.citygml4j.model.citygml.vegetation.SolitaryVegetationObject;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class VegetationMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> typeMapper;

    public VegetationMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(PlantCover.class, this::marshalPlantCover).with(SolitaryVegetationObject.class, this::marshalSolitaryVegetationObject);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public void marshalAbstractVegetationObject(AbstractVegetationObject src, AbstractCityObjectType dest, CityJSON cityJSON) {
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfVegetationObject()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfVegetationObject(), (ExtensibleType)dest, cityJSON);
        }
    }

    public void marshalPlantCover(PlantCover src, PlantCoverType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.marshalAbstractVegetationObject(src, (AbstractCityObjectType)dest, cityJSON);
        PlantCoverAttributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetAverageHeight()) {
            attributes.setAverageHeight(Double.valueOf(src.getAverageHeight().getValue()));
        }
        if (src.isSetGenericApplicationPropertyOfPlantCover()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfPlantCover(), (ExtensibleType)dest, cityJSON);
        }
        if (src.isSetLod1MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            geometry.setLod((Number)1);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSurface())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSurface())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod1MultiSolid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSolid())) != null) {
            geometry.setLod((Number)1);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2MultiSolid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSolid())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3MultiSolid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSolid())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
    }

    public PlantCoverType marshalPlantCover(PlantCover src, CityJSON cityJSON) {
        PlantCoverType dest = new PlantCoverType();
        this.marshalPlantCover(src, dest, cityJSON);
        return dest;
    }

    public void marshalSolitaryVegetationObject(SolitaryVegetationObject src, SolitaryVegetationObjectType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.marshalAbstractVegetationObject(src, (AbstractCityObjectType)dest, cityJSON);
        SolitaryVegetationObjectAttributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetSpecies()) {
            attributes.setSpecies(src.getSpecies().getValue());
        }
        if (src.isSetTrunkDiameter()) {
            attributes.setTrunkDiameter(Double.valueOf(src.getTrunkDiameter().getValue()));
        }
        if (src.isSetCrownDiameter()) {
            attributes.setCrownDiameter(Double.valueOf(src.getCrownDiameter().getValue()));
        }
        if (src.isSetGenericApplicationPropertyOfSolitaryVegetationObject()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfSolitaryVegetationObject(), (ExtensibleType)dest, cityJSON);
        }
        if (src.isSetLod1Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Geometry())) != null) {
            geometry.setLod((Number)1);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod((Number)2);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod((Number)3);
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod1ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation(), 1)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry((AbstractGeometryType)geometry);
        }
    }

    public SolitaryVegetationObjectType marshalSolitaryVegetationObject(SolitaryVegetationObject src, CityJSON cityJSON) {
        SolitaryVegetationObjectType dest = new SolitaryVegetationObjectType();
        this.marshalSolitaryVegetationObject(src, dest, cityJSON);
        return dest;
    }
}

