/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.appearance.AppearanceMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.SurfaceDataInfo;
import org.citygml4j.cityjson.appearance.MaterialType;
import org.citygml4j.cityjson.appearance.TextureType;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.AbstractTextureParameterization;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.ParameterizedTexture;
import org.citygml4j.model.citygml.appearance.TexCoordList;
import org.citygml4j.model.citygml.appearance.TextureAssociation;
import org.citygml4j.model.citygml.appearance.TextureCoordinates;
import org.citygml4j.model.citygml.appearance.X3DMaterial;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.util.walker.GMLWalker;

public class AppearanceResolver {
    private final CityJSONMarshaller json;
    private final AtomicInteger texturesIndex = new AtomicInteger(0);
    private final AtomicInteger materialsIndex = new AtomicInteger(0);
    private final ConcurrentHashMap<TextureType, Integer> textures = new ConcurrentHashMap();
    private final ConcurrentHashMap<MaterialType, Integer> materials = new ConcurrentHashMap();
    private final Map<String, List<SurfaceDataInfo>> globalSurfaceDatas = new ConcurrentHashMap<String, List<SurfaceDataInfo>>();
    private volatile boolean hasGlobalAppearance;

    public AppearanceResolver(CityJSONMarshaller json) {
        this.json = json;
    }

    public void resolve(AbstractCityObject cityObject) {
        this.resolve((AbstractGML)cityObject);
    }

    public void resolve(CityModel cityModel) {
        this.resolve((AbstractGML)cityModel);
    }

    private void resolve(AbstractGML object) {
        Walker walker = new Walker();
        object.accept(walker);
        if (!walker.surfaceDatas.isEmpty()) {
            walker.state = ResolverState.ASSIGN_SURFACE_DATA;
            object.accept(walker);
        }
    }

    public void registerGlobalAppearance(Appearance appearance) {
        Walker walker = new Walker();
        appearance.accept(walker);
        if (!walker.surfaceDatas.isEmpty()) {
            this.globalSurfaceDatas.putAll(walker.surfaceDatas);
            this.hasGlobalAppearance = true;
        }
    }

    public void resolveGlobalAppearance(AbstractGeometry geometry) {
        List<SurfaceDataInfo> surfaceData;
        if (geometry.isSetId() && (surfaceData = this.globalSurfaceDatas.get(geometry.getId())) != null) {
            geometry.setLocalProperty("org.citygml4j.geometry.surfaceData", surfaceData);
        }
    }

    public boolean hasTextures() {
        return !this.textures.isEmpty();
    }

    public List<TextureType> getTextures() {
        List<TextureType> result = this.textures.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.textures.clear();
        this.texturesIndex.set(0);
        return result;
    }

    public boolean hasMaterials() {
        return !this.materials.isEmpty();
    }

    public List<MaterialType> getMaterials() {
        List<MaterialType> result = this.materials.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.materials.clear();
        this.materialsIndex.set(0);
        return result;
    }

    public boolean hasGlobalAppearance() {
        return this.hasGlobalAppearance;
    }

    private class Walker
    extends GMLWalker {
        private final AppearanceMarshaller app;
        private final Map<String, List<SurfaceDataInfo>> surfaceDatas;
        private ResolverState state;
        private String theme;

        private Walker() {
            this.app = AppearanceResolver.this.json.getCityGMLMarshaller().getAppearanceMarshaller();
            this.surfaceDatas = new HashMap<String, List<SurfaceDataInfo>>();
            this.state = ResolverState.GET_SURFACE_DATA;
        }

        @Override
        public void visit(Appearance appearance) {
            this.theme = appearance.isSetTheme() ? appearance.getTheme() : AppearanceResolver.this.json.getFallbackTheme();
            super.visit(appearance);
        }

        @Override
        public void visit(ParameterizedTexture parameterizedTexture) {
            if (this.state == ResolverState.GET_SURFACE_DATA) {
                TextureType texture = this.app.marshalParameterizedTexture(parameterizedTexture);
                if (!texture.isSetImage() || !texture.isSetType()) {
                    return;
                }
                int sequenceNumber = this.addTexture(texture);
                for (TextureAssociation association : parameterizedTexture.getTarget()) {
                    TexCoordList texCoordList;
                    AbstractTextureParameterization parameterization = association.getTextureParameterization();
                    if (!(parameterization instanceof TexCoordList) || !(texCoordList = (TexCoordList)parameterization).isSetTextureCoordinates()) continue;
                    for (TextureCoordinates coordinates : texCoordList.getTextureCoordinates()) {
                        if (!coordinates.isSetRing() || !coordinates.isSetValue()) continue;
                        SurfaceDataInfo info = new SurfaceDataInfo(this.theme, sequenceNumber, parameterizedTexture.getIsFront(), coordinates.getValue());
                        this.addSurfaceData(this.clipGMLId(coordinates.getRing()), info);
                    }
                }
            }
            super.visit(parameterizedTexture);
        }

        @Override
        public void visit(X3DMaterial x3dMaterial) {
            if (this.state == ResolverState.GET_SURFACE_DATA) {
                MaterialType material = this.app.marshalX3DMaterial(x3dMaterial);
                int sequenceNumber = this.addMaterial(material);
                for (String target : x3dMaterial.getTarget()) {
                    if (target == null) continue;
                    SurfaceDataInfo info = new SurfaceDataInfo(this.theme, sequenceNumber, x3dMaterial.getIsFront());
                    this.addSurfaceData(this.clipGMLId(target), info);
                }
            }
            super.visit(x3dMaterial);
        }

        @Override
        public void visit(AbstractGeometry geometry) {
            List<SurfaceDataInfo> surfaceData;
            if (this.state == ResolverState.ASSIGN_SURFACE_DATA && geometry.isSetId() && (surfaceData = this.surfaceDatas.get(geometry.getId())) != null) {
                geometry.setLocalProperty("org.citygml4j.geometry.surfaceData", surfaceData);
            }
            super.visit(geometry);
        }

        @Override
        public void visit(ADEGenericElement ade) {
        }

        private int addTexture(TextureType texture) {
            Integer sequenceNumber = (Integer)AppearanceResolver.this.textures.get(texture);
            if (sequenceNumber == null) {
                int tmp = AppearanceResolver.this.texturesIndex.getAndIncrement();
                sequenceNumber = AppearanceResolver.this.textures.putIfAbsent(texture, tmp);
                if (sequenceNumber == null) {
                    sequenceNumber = tmp;
                }
            }
            return sequenceNumber;
        }

        private int addMaterial(MaterialType material) {
            Integer sequenceNumber = (Integer)AppearanceResolver.this.materials.get(material);
            if (sequenceNumber == null) {
                int tmp = AppearanceResolver.this.materialsIndex.getAndIncrement();
                sequenceNumber = AppearanceResolver.this.materials.putIfAbsent(material, tmp);
                if (sequenceNumber == null) {
                    sequenceNumber = tmp;
                }
            }
            return sequenceNumber;
        }

        private void addSurfaceData(String key, SurfaceDataInfo info) {
            List surfaceData = this.surfaceDatas.computeIfAbsent(key, k -> new ArrayList());
            surfaceData.add(info);
        }

        private String clipGMLId(String target) {
            return target.replaceAll("^.*?#+?", "");
        }
    }

    private static enum ResolverState {
        GET_SURFACE_DATA,
        ASSIGN_SURFACE_DATA;

    }
}

