/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.cityjson.marshal.util.VerticesTransformer;
import org.citygml4j.cityjson.geometry.TransformType;

public class DefaultVerticesTransformer
implements VerticesTransformer {
    private int significantDigits = 3;

    public DefaultVerticesTransformer withSignificantDigits(int significantDigits) {
        if (significantDigits > 0) {
            this.significantDigits = significantDigits;
        }
        return this;
    }

    public int getSignificantDigits() {
        return this.significantDigits;
    }

    @Override
    public TransformType applyTransformation(List<List<Double>> vertices) {
        Double[] translate = new Double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        for (List<Double> vertex : vertices) {
            for (int i = 0; i < vertex.size(); ++i) {
                double value = vertex.get(i);
                if (!(value < translate[i])) continue;
                translate[i] = value;
            }
        }
        double scale = Math.pow(10.0, this.significantDigits);
        for (List<Double> vertex : vertices) {
            for (int i = 0; i < vertex.size(); ++i) {
                vertex.set(i, Double.valueOf((int)((vertex.get(i) - translate[i]) * scale)));
            }
        }
        scale = 1.0 / scale;
        TransformType transform = new TransformType();
        transform.setTranslate(Arrays.asList(translate));
        transform.setScale(Arrays.asList(scale, scale, scale));
        return transform;
    }
}

