/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.AbstractSolidCollectionType;
import org.citygml4j.cityjson.geometry.AbstractSurfaceCollectionType;
import org.citygml4j.cityjson.geometry.MultiLineStringType;
import org.citygml4j.cityjson.geometry.MultiPointType;
import org.citygml4j.cityjson.geometry.SolidType;

public class DuplicateGeometryRemover {
    private final Set<String> mappings = new HashSet<String>();

    public DuplicateGeometryRemover(AbstractCityObjectType parent) {
        for (AbstractGeometryType geometry : parent.getGeometry()) {
            this.mappings.addAll(this.mapGeometry(geometry));
        }
    }

    public void removeDuplicateGeometries(AbstractCityObjectType child) {
        Iterator iter = child.getGeometry().iterator();
        while (iter.hasNext()) {
            AbstractGeometryType geometry = (AbstractGeometryType)iter.next();
            boolean isDuplicate = true;
            for (String mapping : this.mapGeometry(geometry)) {
                if (this.mappings.contains(mapping)) continue;
                isDuplicate = false;
                break;
            }
            if (!isDuplicate) continue;
            iter.remove();
        }
    }

    private Set<String> mapGeometry(AbstractGeometryType geometry) {
        HashSet<String> mappings;
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            mappings = new HashSet<String>();
                            if (!(geometry instanceof MultiPointType)) break block8;
                            MultiPointType multiPoint = (MultiPointType)geometry;
                            for (Integer point : multiPoint.getPoints()) {
                                mappings.add("p" + point.toString());
                            }
                            break block9;
                        }
                        if (!(geometry instanceof MultiLineStringType)) break block10;
                        MultiLineStringType multiLineString = (MultiLineStringType)geometry;
                        for (List lineString : multiLineString.getLineStrings()) {
                            mappings.add(this.mapLineString(lineString));
                        }
                        break block9;
                    }
                    if (!(geometry instanceof AbstractSurfaceCollectionType)) break block11;
                    AbstractSurfaceCollectionType surfaceCollection = (AbstractSurfaceCollectionType)geometry;
                    for (List surface : surfaceCollection.getSurfaces()) {
                        mappings.add(this.mapSurface(surface));
                    }
                    break block9;
                }
                if (!(geometry instanceof SolidType)) break block12;
                SolidType solid = (SolidType)geometry;
                for (List shell : solid.getShells()) {
                    for (List surface : shell) {
                        mappings.add(this.mapSurface(surface));
                    }
                }
                break block9;
            }
            if (!(geometry instanceof AbstractSolidCollectionType)) break block9;
            AbstractSolidCollectionType solidCollection = (AbstractSolidCollectionType)geometry;
            for (List solid : solidCollection.getSolids()) {
                for (List shell : solid) {
                    for (List surface : shell) {
                        mappings.add(this.mapSurface(surface));
                    }
                }
            }
        }
        return mappings;
    }

    private String mapLineString(List<Integer> lineString) {
        return "l" + lineString.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private String mapSurface(List<List<Integer>> surface) {
        return "s" + surface.stream().flatMap(Collection::stream).map(Object::toString).collect(Collectors.joining(","));
    }
}

