/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.AppearanceModuleComponent;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.util.walker.GMLWalker;

public class GeometryXlinkResolver {
    public void resolve(AbstractGML object) {
        Walker walker = new Walker();
        object.accept(walker);
        if (!walker.properties.isEmpty()) {
            walker.state = ResolverState.GET_GEOMETRY;
            object.accept(walker);
        }
    }

    private static class Walker
    extends GMLWalker {
        private ResolverState state = ResolverState.GET_XLINKS;
        private Map<String, List<GeometryProperty<?>>> properties = new HashMap();

        private Walker() {
        }

        @Override
        public <T extends AbstractGeometry> void visit(GeometryProperty<T> property) {
            if (this.state == ResolverState.GET_XLINKS && !property.isSetGeometry() && property.isSetHref()) {
                String key = this.clipGMLId(property.getHref());
                List properties = this.properties.computeIfAbsent(key, k -> new ArrayList());
                properties.add(property);
            }
            super.visit(property);
        }

        @Override
        public void visit(AbstractGeometry geometry) {
            List<GeometryProperty<?>> properties;
            if (this.state == ResolverState.GET_GEOMETRY && geometry.isSetId() && (properties = this.properties.get(geometry.getId())) != null) {
                for (GeometryProperty<?> property : properties) {
                    if (!property.getAssociableClass().isAssignableFrom(geometry.getClass())) continue;
                    property.setLocalProperty("org.citygml4j.geometry.xlink", geometry);
                }
            }
            super.visit(geometry);
        }

        @Override
        public void visit(ADEGenericElement ade) {
        }

        @Override
        public <T extends AbstractFeature> void visit(FeatureProperty<T> property) {
            if (!(property.getFeature() instanceof AppearanceModuleComponent)) {
                super.visit(property);
            }
        }

        private String clipGMLId(String target) {
            return target.replaceAll("^.*?#+?", "");
        }
    }

    private static enum ResolverState {
        GET_XLINKS,
        GET_GEOMETRY;

    }
}

