/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.util.child.ChildInfo;

public class SemanticsBuilder {
    private final AbstractCityObject parent;
    private final CityGMLMarshaller citygml;
    private final List<SemanticsType> surfaces = new ArrayList<SemanticsType>();
    private final Map<AbstractCityObject, Integer> cityObjects = new IdentityHashMap<AbstractCityObject, Integer>();
    private final ChildInfo childInfo = new ChildInfo();

    public SemanticsBuilder(AbstractCityObject parent, CityGMLMarshaller citygml) {
        this.parent = parent;
        this.citygml = citygml;
    }

    public Integer addSemanticSurface(AbstractCityObject cityObject) {
        if (cityObject == null) {
            return null;
        }
        Integer index = null;
        if (!this.cityObjects.containsKey(cityObject)) {
            SemanticsType semantics = this.citygml.marshalSemantics(cityObject);
            if (semantics != null) {
                index = this.surfaces.size();
                this.surfaces.add(semantics);
                AbstractCityObject child = cityObject;
                do {
                    Integer parentIndex;
                    if ((parentIndex = this.cityObjects.get(child = this.childInfo.getParentCityObject(child))) == null || parentIndex >= this.surfaces.size()) continue;
                    SemanticsType parent = this.surfaces.get(parentIndex);
                    parent.addChild(index.intValue());
                    semantics.setParent(parentIndex.intValue());
                    break;
                } while (child != null && child != this.parent);
            }
            this.cityObjects.put(cityObject, index);
        } else {
            index = this.cityObjects.get(cityObject);
        }
        return index;
    }

    public List<SemanticsType> getSurfaces() {
        return this.surfaces;
    }
}

