/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.appearance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.appearance.AbstractMaterialObject;
import org.citygml4j.cityjson.appearance.AbstractTextureObject;
import org.citygml4j.cityjson.appearance.AppearanceType;
import org.citygml4j.cityjson.appearance.MaterialType;
import org.citygml4j.cityjson.appearance.TextureType;
import org.citygml4j.model.citygml.appearance.AbstractSurfaceData;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.appearance.Color;
import org.citygml4j.model.citygml.appearance.ColorPlusOpacity;
import org.citygml4j.model.citygml.appearance.ParameterizedTexture;
import org.citygml4j.model.citygml.appearance.SurfaceDataProperty;
import org.citygml4j.model.citygml.appearance.TexCoordList;
import org.citygml4j.model.citygml.appearance.TextureAssociation;
import org.citygml4j.model.citygml.appearance.TextureCoordinates;
import org.citygml4j.model.citygml.appearance.WrapMode;
import org.citygml4j.model.citygml.appearance.X3DMaterial;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.LinearRing;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.gmlid.GMLIdManager;
import org.citygml4j.util.walker.GeometryWalker;

public class AppearanceUnmarshaller {
    private final CityJSONUnmarshaller json;
    private List<MaterialType> materials;
    private List<TextureType> textures;
    private List<List<Double>> textureVertices;
    private int numTextureVertices;
    private GMLIdManager gmlIdManager;

    public AppearanceUnmarshaller(CityGMLUnmarshaller citygml) {
        this.json = citygml.getCityJSONUnmarshaller();
    }

    public void setAppearanceInfo(AppearanceType appearanceType) {
        this.materials = appearanceType.getMaterials();
        this.textures = appearanceType.getTextures();
        this.textureVertices = appearanceType.getTextureVertices();
        this.numTextureVertices = this.textureVertices != null ? this.textureVertices.size() : 0;
        this.gmlIdManager = DefaultGMLIdManager.getInstance();
    }

    public void unmarshalMaterial(AbstractMaterialObject src, Map<Integer, List<AbstractSurface>> surfaces, AbstractCityObject parent) {
        Appearance appearance = this.getOrCreateAppearance(src.getTheme(), parent);
        for (Map.Entry<Integer, List<AbstractSurface>> entry : surfaces.entrySet()) {
            MaterialType materialType;
            MaterialType materialType2 = materialType = this.materials != null ? this.materials.get(entry.getKey()) : null;
            if (materialType == null) continue;
            X3DMaterial material = this.getOrCreateX3DMaterial(materialType, entry.getKey(), appearance);
            for (AbstractSurface surface : entry.getValue()) {
                if (!surface.isSetId()) {
                    surface.setId(this.gmlIdManager.generateUUID());
                }
                material.addTarget("#" + surface.getId());
            }
        }
    }

    public void unmarshalParameterizedTexture(AbstractTextureObject src, Map<Integer, List<AbstractSurface>> surfaces, AbstractCityObject parent) {
        Appearance appearance = this.getOrCreateAppearance(src.getTheme(), parent);
        for (Map.Entry<Integer, List<AbstractSurface>> entry : surfaces.entrySet()) {
            ParameterizedTexture texture;
            TextureType textureType = this.textures != null ? this.textures.get(entry.getKey()) : null;
            if (textureType == null || (texture = this.getOrCreateParameterizedTexture(textureType, entry.getKey(), appearance)) == null) continue;
            for (AbstractSurface surface : entry.getValue()) {
                final TexCoordList texCoordList = new TexCoordList();
                final List values = (List)surface.getLocalProperty("org.citygml4j.textureCoordinates");
                final int[] i = new int[]{-1};
                surface.accept(new GeometryWalker(){

                    @Override
                    public void visit(LinearRing linearRing) {
                        i[0] = i[0] + 1;
                        if (i[0] < values.size()) {
                            List value = (List)values.get(i[0]);
                            if (value == null || value.size() < 2) {
                                return;
                            }
                            List coords = AppearanceUnmarshaller.this.getTextureVertices(value);
                            if (coords.isEmpty()) {
                                return;
                            }
                            coords.addAll(coords.subList(0, 2));
                            if (!linearRing.isSetId()) {
                                linearRing.setId(AppearanceUnmarshaller.this.gmlIdManager.generateUUID());
                            }
                            TextureCoordinates textureCoordinates = new TextureCoordinates();
                            textureCoordinates.setRing("#" + linearRing.getId());
                            textureCoordinates.setValue(coords);
                            texCoordList.addTextureCoordinates(textureCoordinates);
                        }
                    }
                });
                if (!texCoordList.isSetTextureCoordinates()) continue;
                if (!surface.isSetId()) {
                    surface.setId(this.gmlIdManager.generateUUID());
                }
                TextureAssociation target = new TextureAssociation();
                target.setUri("#" + surface.getId());
                target.setTextureParameterization(texCoordList);
                texture.addTarget(target);
            }
        }
    }

    public void unmarshalParameterizedTexture(TextureType src, ParameterizedTexture dest) {
        List color;
        if (src.isSetImage()) {
            String imageURI = this.json.getTextureFileHandler().getImageURI(src.getImage());
            if (imageURI == null) {
                return;
            }
            dest.setImageURI(imageURI);
        }
        if (src.isSetType()) {
            dest.setMimeType(new Code(src.getType().getMimeType()));
        }
        if (src.isSetWrapMode()) {
            dest.setWrapMode(WrapMode.fromValue(src.getWrapMode().getValue()));
        }
        if (src.isSetTextureType()) {
            dest.setTextureType(org.citygml4j.model.citygml.appearance.TextureType.fromValue(src.getTextureType().getValue()));
        }
        if (src.isSetBorderColor() && (color = src.getBorderColor()) != null) {
            if (color.size() == 3) {
                dest.setBorderColor(new ColorPlusOpacity((Double)color.get(0), (Double)color.get(1), (Double)color.get(2)));
            } else if (color.size() > 3) {
                dest.setBorderColor(new ColorPlusOpacity((Double)color.get(0), (Double)color.get(1), (Double)color.get(2), (Double)color.get(3)));
            }
        }
    }

    public ParameterizedTexture unmarshalParameterizedTexture(TextureType src) {
        ParameterizedTexture dest = new ParameterizedTexture();
        this.unmarshalParameterizedTexture(src, dest);
        return dest;
    }

    public void unmarshalMaterial(MaterialType src, X3DMaterial dest) {
        List color;
        if (src.isSetName()) {
            dest.addName(new Code(src.getName()));
        }
        if (src.isSetAmbientIntensity()) {
            dest.setAmbientIntensity(src.getAmbientIntensity());
        }
        if (src.isSetDiffuseColor() && (color = src.getDiffuseColor()) != null && color.size() > 2) {
            dest.setDiffuseColor(new Color((Double)color.get(0), (Double)color.get(1), (Double)color.get(2)));
        }
        if (src.isSetEmissiveColor() && (color = src.getEmissiveColor()) != null && color.size() > 2) {
            dest.setEmissiveColor(new Color((Double)color.get(0), (Double)color.get(1), (Double)color.get(2)));
        }
        if (src.isSetSpecularColor() && (color = src.getSpecularColor()) != null && color.size() > 2) {
            dest.setSpecularColor(new Color((Double)color.get(0), (Double)color.get(1), (Double)color.get(2)));
        }
        if (src.isSetShininess()) {
            dest.setShininess(src.getShininess());
        }
        if (src.isSetTransparency()) {
            dest.setTransparency(src.getTransparency());
        }
        if (src.isSmooth()) {
            dest.setIsSmooth(src.isSmooth());
        }
    }

    public X3DMaterial unmarshalMaterial(MaterialType src) {
        X3DMaterial dest = new X3DMaterial();
        this.unmarshalMaterial(src, dest);
        return dest;
    }

    private Appearance getOrCreateAppearance(String theme, AbstractCityObject parent) {
        Appearance dest = null;
        for (AppearanceProperty property : parent.getAppearance()) {
            Appearance appearance = property.getAppearance();
            if ((theme.isEmpty() || !theme.equals(appearance.getTheme())) && (!theme.isEmpty() || appearance.isSetTheme())) continue;
            dest = appearance;
            break;
        }
        if (dest == null) {
            dest = new Appearance();
            if (!theme.isEmpty()) {
                dest.setTheme(theme);
            }
            parent.addAppearance(new AppearanceProperty(dest));
        }
        return dest;
    }

    private X3DMaterial getOrCreateX3DMaterial(MaterialType src, int surfaceDataId, Appearance appearance) {
        X3DMaterial dest = null;
        for (SurfaceDataProperty property : appearance.getSurfaceDataMember()) {
            X3DMaterial material;
            AbstractSurfaceData surfaceData = property.getSurfaceData();
            if (!(surfaceData instanceof X3DMaterial) || (Integer)(material = (X3DMaterial)surfaceData).getLocalProperty("org.citygml4j.appearance.id") != surfaceDataId) continue;
            dest = material;
            break;
        }
        if (dest == null) {
            dest = this.unmarshalMaterial(src);
            dest.setLocalProperty("org.citygml4j.appearance.id", surfaceDataId);
            appearance.addSurfaceDataMember(new SurfaceDataProperty(dest));
        }
        return dest;
    }

    private ParameterizedTexture getOrCreateParameterizedTexture(TextureType src, int surfaceDataId, Appearance appearance) {
        ParameterizedTexture dest = null;
        for (SurfaceDataProperty property : appearance.getSurfaceDataMember()) {
            ParameterizedTexture texture;
            AbstractSurfaceData surfaceData = property.getSurfaceData();
            if (!(surfaceData instanceof ParameterizedTexture) || (Integer)(texture = (ParameterizedTexture)surfaceData).getLocalProperty("org.citygml4j.appearance.id") != surfaceDataId) continue;
            dest = texture;
            break;
        }
        if (dest == null) {
            dest = this.unmarshalParameterizedTexture(src);
            if (!dest.isSetImageURI()) {
                return null;
            }
            dest.setLocalProperty("org.citygml4j.appearance.id", surfaceDataId);
            appearance.addSurfaceDataMember(new SurfaceDataProperty(dest));
        }
        return dest;
    }

    private List<Double> getTextureVertices(List<Integer> indexes) {
        ArrayList<Double> vertices = new ArrayList<Double>();
        for (int i = 1; i < indexes.size(); ++i) {
            List<Double> vertex;
            Integer index = indexes.get(i);
            if (index == null || index >= this.numTextureVertices || (vertex = this.textureVertices.get(index)) == null || vertex.size() != 2) continue;
            vertices.addAll(vertex);
        }
        return vertices;
    }
}

